# coding=utf-8
from datetime import datetime, timedelta

from library.python import resource
from travel.hotels.lib.python import yqllib
from travel.hotels.lib.python.versioned_process import VersionedProcess
from yql.api.v1.client import YqlClient


class ColdBuilder(VersionedProcess):
    name = 'cold'

    def __init__(self, session, args):
        super(ColdBuilder, self).__init__(session, args)
        self.yql_client = YqlClient(token=args.yql_token, db=args.yt_proxy)
        self.env = args.env
        self.num_days = args.num_days

    @staticmethod
    def configure_arg_parser(parser, proc_env):
        arg_group = parser.add_argument_group(ColdBuilder.name)
        arg_group.add_argument('--yql-token', required=True)
        arg_group.add_argument('--env', choices=['testing', 'prod'], required=True)
        arg_group.add_argument('--num-days', type=int, required=True)

    @staticmethod
    def date_to_str(dt):
        return dt.strftime('%Y-%m-%d')

    def run(self):
        end_date = datetime.today() - timedelta(days=1)
        start_date = end_date - timedelta(days=(self.num_days - 1))
        query = resource.find('query.yql')
        parameters = {
            '$start_date': self.date_to_str(start_date),
            '$end_date': self.date_to_str(end_date),
            '$lifetime_path': self.get_table_path('lifetime'),
            '$env': self.env,
        }
        request = yqllib.run_query(query=query, parameters=parameters, client=self.yql_client, debug=self.debug, syntax_version=1)
        yqllib.wait_results(request)


if __name__ == '__main__':
    ColdBuilder.main()
