from typing import Dict, Any

from travel.hotels.tools.dataset_curator.data import Dataset
from travel.hotels.tools.dataset_curator.dataset_build_configuration import InnerBuildContext, BuildContext

from yt.wrapper import ypath_split

from jinja2 import StrictUndefined
from jinja2.nativetypes import NativeEnvironment


def yt_table_name(value):
    return ypath_split(value)[1]


def create_auto_build_context(dataset: Dataset, yt_cluster: str) -> InnerBuildContext:
    if dataset.build is None or dataset.build.builder is None:
        raise Exception('Builder config section is required for auto build context')

    builder = dataset.build.builder
    env = NativeEnvironment(undefined=StrictUndefined)
    env.filters["yt_table_name"] = yt_table_name

    def build(ctx: BuildContext, args: Dict[str, Any]):
        ctx.run_yql_builder(
            builder.specific_builder_configuration.query_path,
            yql_params={
                k: env.from_string(v).render(args=args, ctx=ctx, vars=dataset.template_vars)
                for k, v in builder.specific_builder_configuration.yql_params.items()
            },
        )

    return InnerBuildContext(dataset.name, build, yt_cluster, builder.versioned_process, builder.create_latest, builder.transfer_results, builder.skip_empty, builder.skip_unexistent)
