def onlyletters(sentence):
    res = [item if ('а' <= item <= 'я') or ('a' <= item <= 'z') or ('0' <= item <= '9') or item == ' ' else ' ' for item in sentence]
    return ''.join(res)

stopwords = ['на', 'с', 'для', 'в']

def preprocess_text(sentence):
    sentence = sentence.decode('utf-8')
    sentence = onlyletters(sentence.lower()).split(' ')
    new_sentence = []
    for word in sentence:
        new_word = word
        if new_word == 'номер':
            continue
        if new_word in stopwords:
            continue
        if new_word.startswith('студи'):
            new_word = 'студия'
        new_sentence.append(new_word)
    return (' '.join(new_sentence)).encode('utf-8')

def convert_room_name_to_useful(room_name, partner_id):
    if room_name is None:
        return None

    room_name = room_name.decode('utf-8')
    room_name = room_name.lower()
    if ' × ' in room_name:
        splitted_x = room_name.split(' × ')
        room_name = splitted_x[len(splitted_x) - 1]
    if ' - ' in room_name and partner_id == 2:
        splitted_sep = room_name.split(' - ')
        room_name = splitted_sep[0]
    return preprocess_text(room_name.encode('utf-8'))
