def onlyletters(sentence):
    res = [item if ('а' <= item <= 'я') or ('a' <= item <= 'z') or ('0' <= item <= '9') or item == ' ' else ' ' for item in sentence]
    return ''.join(res)

stopwords = ["с", "и", "для", "или", "на", "в", "з", "из", "по", "во", "а", "к", "за", "х", "and", "so", "c", "in", "м", "with", "ти", "д", "до", "ми", "б", "й", "тр", "ой", "у", "от", "for", "мя", "of", "b", "эта", "without", "х", "но", "x", "ех", "класс", "the", "2х2", "кв", "ул", "при", "со", "hb", "bb", "or", "to"]
dictionary = [{"main_form": "номер", "base": "^номе.{0,2}$"}, {"main_form": "комната", "base": "(^комнат.?$)|(^room.?$)|(^комн$)"}, {"main_form": "двуспальный", "base": "^двух?спальн.{1,5}$"}, {"main_form": "односпальный", "base": "(^односпаль.{1,5}$)|(^отдельн.{0,6}$)"}, {"main_form": "улучшенный", "base": "(^улучшать$)|(^улучшенн?.+$)|(^super.+$)|(^супери.{1,3})"}, {"main_form": "кровать", "base": "(^кроват.{0,5}$)|(^bed.?$)"}, {"main_form": "стандартный", "base": "(^стандар?.{0,4})|(^standar.)|(^cтандарт$)"}, {"main_form": "люкс", "base": "(^люкс.?$)|(^с[юиьу]{2,3}т.?$)|(^suite?$)|(^lux.{0,4}$)"}, {"main_form": "общий", "base": "^общи.{1,3}$"}, {"main_form": "тип", "base": "^тип$"}, {"main_form": "ванна", "base": "^ванн?.{1,3}$"}, {"main_form": "мочь", "base": "^мочь$"}, {"main_form": "изменение", "base": "^измен.{3,6}$"}, {"main_form": "комфорт", "base": "(^комфорт$)|(^комфортн.{1,4}$)|(^комфортабе.{1,6}$)|(^comf.{1,5})"}, {"main_form": "эконом", "base": "(^эконом.*$)|(^econom.?$)"}, {"main_form": "семейный", "base": "(^семейн.{1,4}$)|(^family$)"}, {"main_form": "делюкс", "base": "(^делюкс$)|(^delux.?$)"}, {"main_form": "полулюкс", "base": "^.?полулюкс?.?$"}, {"main_form": "вид", "base": "(^вид.{0,3}$)|(^vie.$)"}, {"main_form": "апартаменты", "base": "(^апартамен?ты?$)|(^квартирк?а$)|(^aparta?ment$)|(^апарт$)"}, {"main_form": "один", "base": "(^1\\D{0,3}$)|(^один$)|(^первый$)|(^one$)|(^i$)"}, {"main_form": "два", "base": "(^2\\D{0,3}$)|(^два$)|(^второй)|(^two)|(^двумя$)|(^ii$)"}, {"main_form": "три", "base": "(^3\\D{0,3}$)|(^три$)|(^третий$)|(^three$)|(^iii$)"}, {"main_form": "четыре", "base": "(^4\\D{0,3}$)|(^четыре$)|(^четвертый$)|(^four)|(^четыр$)|(^iiii$)|(^iv$)"}, {"main_form": "пять", "base": "(^5\\D{0,3}$)|(^пять$)|(^пятый$)|(^five$)|(^v$)"}, {"main_form": "шесть", "base": "(^6\\D{0,3}$)|(^шесть$)|(^шестой$)|(^six)|(^vi$)"}, {"main_form": "семь", "base": "(^7\\D{0,3}$)|(^семь$)|(^седьмой$)|(^seven$)"}, {"main_form": "восемь", "base": "(^8\\D{0,3}$)|(^восемь$)|(^восьмой$)|(^eight)"}, {"main_form": "девять", "base": "(^9\\D{0,3}$)|(^девять$)|(^девятый$)|(^nine$)"}, {"main_form": "десять", "base": "(^10\\D{0,3}$)|(^десять$)|(^десятый$)|(^ten$)"}, {"main_form": "одиннадцать", "base": "(^11\\D{0,3}$)|(^одиннадцать$)|(^одинн?адцатый$)"}, {"main_form": "двенадцать", "base": "(^12\\D{0,3}$)|(^двенадцать$)|(^двенн?адцатый$)"}, {"main_form": "тринадцать", "base": "(^13\\D{0,3}$)|(^тр.?надцать$)|(^тринадцатый$)"}, {"main_form": "четырнадцать", "base": "(^14\\D{0,3}$)|(^четырнадцать$)|(^четырнадцатый$)"}, {"main_form": "пятнадцать", "base": "(^15\\D{0,3}$)|(^пятнадцать$)|(^пятнадцатый$)"}, {"main_form": "шестнадцать", "base": "(^16\\D{0,3}$)|(^шестнадцать$)|(^шестнадцатый$)"}, {"main_form": "восемнадцать", "base": "(^18\\D{0,3}$)|(^восемнадцать$)|(^восемнадцатый$)"}, {"main_form": "двадцать", "base": "(^20\\D{0,3}$)|(^двадцать$)|(^двадцатый$)"}, {"main_form": "двадцатьодин", "base": "(^21\\D{0,3}$)|(^двадцатьодин$)|(^двадцатьпервый$)"}, {"main_form": "двадцатьдва", "base": "(^22\\D{0,3}$)|(^двадцатьдва$)|(^двадцатьвторой$)"}, {"main_form": "двадцатьчетыре", "base": "(^24\\D{0,3}$)|(^двадцатьчетыре$)|(^двадцатьчетвертый$)"}, {"main_form": "двадцатьшесть", "base": "(^26\\D{0,3}$)|(^двадцатьшесть$)|(^двадцатьшестой$)"}, {"main_form": "двадцатьвосемь", "base": "(^28\\D{0,3}$)|(^двадцатьвосемь$)|(^двадцатьвосемой$)"}, {"main_form": "студия", "base": "(^студи.$)|(^stud.{0,2}$)"}, {"main_form": "гость", "base": "(^гост.{1,2}$)|(^guest$)"}, {"main_form": "одноместный", "base": "(^одноместн.{0,7}$)|(^1\\D.*ест.*$)|(^1\\D.*ed.*$)|(^мест\\.1$)"}, {"main_form": "двухместный", "base": "(^двух?мест?н.{0,7}$)|(^2\\D.*ест.*$)|(^2\\D.*ed.*$)|(^мест\\.2$)"}, {"main_form": "трехместный", "base": "(^трехместн.{1,7}$)|(^3\\D.*ест.*$)|(^3\\D.*ed.*$)"}, {"main_form": "четырехместный", "base": "(^четырех?местн.{1,7}$)|(^4\\D.*ест.*$)|(^4\\D.*ed.*$)"}, {"main_form": "пятиместный", "base": "(^пятиместн.{1,7}$)|(5\\D.*ест.*$)|(^5\\D.*ed.*$)"}, {"main_form": "шестиместный", "base": "(^шестиместн.{1,7}$)|(^6\\D.*ест.*$)|(^6\\D.*ed.*$)"}, {"main_form": "семиместный", "base": "(^семиместн.{1,7}$)|(^7\\D.*ест.*$)|(^7\\D.*ed.*$)"}, {"main_form": "восьмиместный", "base": "(^восьмиместн.{1,7}$)|(^8\\D.*ест.*$)|(^8\\D.*ed.*$)|(^восемиместный$)"}, {"main_form": "девятиместный", "base": "(^девятиместн.{1,7}$)|(^9\\D.*ест.*$)|(^9\\D.*ed.*$)"}, {"main_form": "десятиместный", "base": "(^десятиместн.{1,7}$)|(^10\\D.*ест.*$)|(^10\\D.*ed.*$)"}, {"main_form": "одиннадцатиместный", "base": "(^одиннадцатиместн.{1,4}$)|(^11\\D.*ест.*$)|(^11\\D.*ed.*$)"}, {"main_form": "двенадцатиместный", "base": "(^двенадцатиместн.{1,4}$)|(^12\\D.*ест.*$)|(^12\\D.*ed.*$)"}, {"main_form": "тринадцатиместный", "base": "(^тринадцатиместн.{1,4}$)|(^13\\D.*ест.*$)|(^13\\D.*ed.*$)"}, {"main_form": "четырнадцатиместный", "base": "(^четырнадцатиместн.{1,4}$)|(^14\\D.*ест.*$)|(^14\\D.*ed.*$)"}, {"main_form": "шестнадцатиместный", "base": "(^шестнадцатиместн.{1,4}$)|(^16\\D.*ест.*$)|(^16\\D.*ed.*$)"}, {"main_form": "восемнадцатиместный", "base": "(^восемнадцатиместн.{1,4}$)|(^18\\D.*ест.*$)|(^18\\D.*ed.*$)"}, {"main_form": "двадцатиместный", "base": "(^двадцатиместн.{1,4}$)|(^20\\D.*ест.*$)|(^20\\D.*ed.*$)"}, {"main_form": "двадцатиодноместный", "base": "(^двадцатиодноместн.{1,4}$)|(^21\\D.*ест.*$)|(^21\\D.*ed.*$)"}, {"main_form": "двадцатидвухместный", "base": "(^двадцатидвухместн.{1,4}$)|(^22\\D.*ест.*$)|(^22\\D.*ed.*$)"}, {"main_form": "двадцатичетырехместный", "base": "(^двадцатичетырехместн.{1,4}$)|(^24\\D.*ест.*$)|(^24\\D.*ed.*$)"}, {"main_form": "двадцатишестиместный", "base": "(^двадцатишестиместн.{1,4}$)|(^26\\D.*ест.*$)|(^26\\D.*ed.*$)"}, {"main_form": "двадцативосьмиместный", "base": "(^двадцативосьмиместн.{1,4}$)|(^28\\D.*ест.*$)|(^28\\D.*ed.*$)"}, {"main_form": "балкон", "base": "(^балкон.{0,3}$)|(^лоджия$)|(^balcony$)"}, {"main_form": "спальня", "base": "(^спальн.{1,4}$)|(^bedroom.?$)|(^dormitory$)|(^dorm$)"}, {"main_form": "диван", "base": "(^диван.?$)|(^sofa$)"}, {"main_form": "размер", "base": "^размер.?$"}, {"main_form": "женщина", "base": "(^женщин.?$)|(^женск.{1,3}$)|(^female$)"}, {"main_form": "мужчина", "base": "(^мужчин.?$)|(^мужск.{1,3}$)|(^male$)"}, {"main_form": "включать", "base": "^вкл(ючать)?$"}, {"main_form": "бизнес", "base": "(^бизнес.{0,3}$)|(^busines.$)"}, {"main_form": "бюджетный", "base": "^бюджетный$"}, {"main_form": "море", "base": "(^море$)|(^морской$)|(^sea$)"}, {"main_form": "классический", "base": "(^классический$)|(^классик$)|(^classic$)"}, {"main_form": "без", "base": "^без$"}, {"main_form": "окно", "base": "(^окно$)|(^window$)"}, {"main_form": "город", "base": "(^(на)?город$)|(^city$)|(^сити$)"}, {"main_form": "представительский", "base": "(^представительск.{1,2}$)|(^executive$)"}, {"main_form": "размер", "base": "(^size$)|(^сайз$)"}, {"main_form": "премиум", "base": "(^премиум)|(^premium$)$"}, {"main_form": "двухъярусный", "base": "^двух?ъ?ярусный$"}, {"main_form": "коттедж", "base": "^коттедж.?$"}, {"main_form": "не", "base": "(^не$)|(^non?$)"}, {"main_form": "собственный", "base": "^собственный$"}, {"main_form": "кухня", "base": "^кухня$"}, {"main_form": "большой", "base": "^(большой$)|(^large$)"}, {"main_form": "небольшой", "base": "^небольшой$"}, {"main_form": "некурящий", "base": "^некурящи.$"}, {"main_form": "курящий", "base": "^курящий$"}, {"main_form": "мансарда", "base": "(^мансард.{1,3}$)|(^mansard$)|(^attic$)"}, {"main_form": "детский", "base": "^детский$"}, {"main_form": "душ", "base": "(^душ.?$)|(^душев.{1,2}$)|(^shower)"}, {"main_form": "река", "base": "(^река$)|(^river)"}, {"main_form": "терраса", "base": "^терр?асс?.*$"}, {"main_form": "доступ", "base": "(^доступ.{0,2}$)|(^access$)"}, {"main_form": "проживание", "base": "^проживание$"}, {"main_form": "главное", "base": "^главн.{0,2}$"}, {"main_form": "президентский", "base": "^президентский$"}, {"main_form": "king", "base": "(^king$)|(^кинг$)$"}, {"main_form": "queen", "base": "(^queen$)|(^квин$)$"}, {"main_form": "здание", "base": "(^здание$)|(^bu?i?ldi?n?g$)"}, {"main_form": "взрослый", "base": "(^взросл.{2,3}$)|(^adu?lt$)"}, {"main_form": "дом", "base": "^дом.{0,2}$"}, {"main_form": "внутренний", "base": "^внутренний$"}, {"main_form": "двор", "base": "(^двор$)|(^дворик$)"}, {"main_form": "гидромассажный", "base": "^гидромассаж.{0,4}$"}, {"main_form": "озеро", "base": "^озер.{1,3}$"}, {"main_form": "сад", "base": "^сад$"}, {"main_form": "повышенный", "base": "^повышенный$"}, {"main_form": "премьер", "base": "^премьер.{0,5}$"}, {"main_form": "клуб", "base": "(^клуб.{0,3}$)|(^club$)"}, {"main_form": "сауна", "base": "(^саун.{1,2}$)|(^бан((я)|(ный))$)"}, {"main_form": "возможность", "base": "^возможность$"}, {"main_form": "этаж", "base": "(^этаж$)|(^floor$)"}, {"main_form": "ограниченный", "base": "^ограничен.{1,3}$"}, {"main_form": "дуплекс", "base": "(^дуплекс$)|(^duplex$)"}, {"main_form": "джакузи", "base": "^джакузи$"}, {"main_form": "двухуровневый", "base": "^двух?ъ?уровнев.{1,3}$"}, {"main_form": "категория", "base": "^категор.{1,4}$"}, {"main_form": "корпус", "base": "^корпу?с?.?$"}, {"main_form": "однокомнатный", "base": "(^однокомн.*$)|(^1\\D.*омна.*$)"}, {"main_form": "двухкомнатный", "base": "(^двух?ком.*$)|(^2\\D.*омна.*$)"}, {"main_form": "трехкомнатный", "base": "(^трех?ком.*$)|(^3\\D.*омна.*$)"}, {"main_form": "четырехкомнатный", "base": "(^четырех?ком.*$)|(^4\\D.*омна.*$)"}, {"main_form": "twin", "base": "(^twi?n$)|(^твин$)"}, {"main_form": "раздельный", "base": "^раздельны.{1,4}$"}, {"main_form": "человек", "base": "(^человек.?$)|(^people$)"}, {"main_form": "помещение", "base": "^помещение$"}, {"main_form": "junior$", "base": "(^джуниор$)|(^junior$)|(^junior\\$$)"}, {"main_form": "час", "base": "(^час$)|(^часовой$)|(^hour$)"}, {"main_form": "double", "base": "(^doubl.{0,4}$)|(^дабл.?$)|(^dbl.{0,3}$)"}, {"main_form": "triple", "base": "(^trip.{1,4}$)|(^trpl$)"}, {"main_form": "single", "base": "(^singl?e?.{0,4}$)|(^сингл.?$)|(^sng.{0,3}$)"}, {"main_form": "панорамный", "base": "(^панорам.{0,5}$)|(^panoram.{0,4})"}, {"main_form": "бассейн", "base": "^бассейн.{0,3}$"}, {"main_form": "несколько", "base": "^несколько$"}, {"main_form": "капсула", "base": "(^капсул.{0,6}$)|(^capsule$)"}, {"main_form": "смешанный", "base": "^смешанн?ый$"}, {"main_form": "базовый", "base": "(^базовый$)|(^basic$)"}, {"main_form": "парк", "base": "(^парк$)|(^парковый$)|(^park$)"}, {"main_form": "спа", "base": "(^спа$)|(^spa$)"}, {"main_form": "только", "base": "(^только$)|(^only$)"}, {"main_form": "мини", "base": "(^мини$)|(^mini$)"}, {"main_form": "плюс", "base": "(^плюс$)|(^plus$)"}, {"main_form": "лаунж", "base": "(^лаунд?ж.?)|(^lounge$)"}, {"main_form": "предложение", "base": "(^предложение.?$)|(^offer$)"}, {"main_form": "размещение", "base": "^размещение.?$"}, {"main_form": "специальный", "base": "(^специальный$)|(^special$)"}, {"main_form": "удобство", "base": "^удобство$"}, {"main_form": "вилла", "base": "(^вилла$)|(^villa$)"}, {"main_form": "wifi", "base": "^wifi$"}, {"main_form": "верхний", "base": "^верхний$"}, {"main_form": "ночь", "base": "^ночь$"}, {"main_form": "отель", "base": "(^отель.{0,4}$)|(^миниотель.{0,4}$)|(^экоотель.{0,4}$)"}, {"main_form": "частичный", "base": "^частичный$"}, {"main_form": "центр", "base": "(^центр$)|(^центральный$)"}, {"main_form": "шале", "base": "^шал.?$"}, {"main_form": "привелегия", "base": "^(^привелегия$)|(^privilege)|(^privelege$)"}, {"main_form": "гранд", "base": "(^гранд$)|(^grand$)"}, {"main_form": "лечение", "base": "^лечение$"}, {"main_form": "дизайнерский", "base": "(^дизайн.*$)|(^design$)"}, {"main_form": "гора", "base": "(^гора$)|(^горный$)"}, {"main_form": "цоколь", "base": "^цоколь.{0,5}$"}, {"main_form": "блок", "base": "^блок$"}, {"main_form": "vip", "base": "(^vip)|(^вип$)$"}, {"main_form": "посещение", "base": "^посещение$"}, {"main_form": "нижний", "base": "^нижн.й$"}, {"main_form": "площадь", "base": "(^площадь$)|(^square$)"}, {"main_form": "более", "base": "^более$"}, {"main_form": "бунгало", "base": "(^бунгало$)|(^bungalow$)"}, {"main_form": "swiss", "base": "^swiss$"}, {"main_form": "гостиная", "base": "^гостиная$"}, {"main_form": "окрестность", "base": "^окрестность$"}, {"main_form": "камин", "base": "^камин.{0,4}$"}, {"main_form": "эксклюзивный", "base": "(^эксклюзив.{0,4}$)|(^exclusive$)"}, {"main_form": "холодильник", "base": "^холодильник.{0,4}$"}, {"main_form": "новобрачные", "base": "(^новобрачн.{0-6}$)|(^новобрачные$)"}, {"main_form": "event", "base": "^событие$"}, {"main_form": "просторный", "base": "^просторный$"}, {"main_form": "кондиционер", "base": "^кондиционер.{0,2}$"}, {"main_form": "услуга", "base": "^услуг.{0,2}$"}, {"main_form": "распродажа", "base": "^распродажа$"}, {"main_form": "вода", "base": "^вод.$"}, {"main_form": "пакет", "base": "^пакет$"}, {"main_form": "угловой", "base": "^угловой$"}, {"main_form": "дополнительный", "base": "(^доп.$)|(^допмест.{0,4}$)|(^дополнительный$)"}, {"main_form": "гостевой", "base": "^гостевой$"}, {"main_form": "софа", "base": "(^софа$)|(^софой$)"}, {"main_form": "таунхаус", "base": "^таунха.{0,5}$"}, {"main_form": "широкий", "base": "^широкий$"}, {"main_form": "суперлюкс", "base": "^суперлюкс$"}, {"main_form": "оздоровительный", "base": "^оздоров.+$"}, {"main_form": "право", "base": "^прав.{1,2}$"}, {"main_form": "романтический", "base": "(^романти.+$)|(^romantic$)"}, {"main_form": "боковой", "base": "^боковой$"}, {"main_form": "собор", "base": "(^собор$)|(^cathedral$)"}, {"main_form": "бюджет", "base": "^бюджет$"}, {"main_form": "туалет", "base": "(^санузел$)|(^туалет$)"}, {"main_form": "выход", "base": "^выход$"}, {"main_form": "внешний", "base": "^внешний$"}, {"main_form": "лес", "base": "(^лес$)|(^лесн.{0,4}$)"}, {"main_form": "гостиница", "base": "^гостин[^а].{0,6}$"}, {"main_form": "аквапарк", "base": "^аквапарк$"}, {"main_form": "новый", "base": "^новый$"}, {"main_form": "одноэтажный", "base": "(^одноэтаж.{1,4})|(^1\\D.*этаж.*)"}, {"main_form": "двухэтажный", "base": "(^двухэтаж.{1,4})|(^2\\D.*этаж.*)"}, {"main_form": "трехэтажный", "base": "(^трехэтаж.{1,4})|(^3\\D.*этаж.*)"}, {"main_form": "пентхаус", "base": "^пентхаус$"}, {"main_form": "королевский", "base": "(^королевский$)|(^royal$)"}, {"main_form": "залив", "base": "^залив$"}, {"main_form": "посейдон", "base": "^посейдон$"}, {"main_form": "лофт", "base": "(^лофт)|(^lofty?$)$"}, {"main_form": "ребенок", "base": "^ребенок$"}, {"main_form": "смежный", "base": "^смежный$"}, {"main_form": "ярус", "base": "^ярус.{0,4}$"}, {"main_form": "комплекс", "base": "^комплекс$"}, {"main_form": "пляж", "base": "(^пляж.{0,4}$)|(^beachfront$)"}, {"main_form": "кресло", "base": "^кресло$"}, {"main_form": "физический", "base": "^физический$"}, {"main_form": "процедура", "base": "^процедура$"}, {"main_form": "традиционный", "base": "^традиционный$"}, {"main_form": "хостел", "base": "^хостелe?$"}, {"main_form": "улица", "base": "(^улица$)|(^stre?e?t?$)"}, {"main_form": "кремль", "base": "^кремл.+$"}, {"main_form": "заезд", "base": "^заезд.{0,2}$"}, {"main_form": "вход", "base": "^вход.{0,4}$"}, {"main_form": "атриум", "base": "^атриум$"}, {"main_form": "высокий", "base": "^высо((та)|(кий))$"}, {"main_form": "губернский", "base": "^губерн((ский)|(тор))$"}, {"main_form": "завтрак", "base": "^завтрак$"}, {"main_form": "основной", "base": "^основн.{1,4}$"}, {"main_form": "свадебный", "base": "^свадебн.{0,3}$"}, {"main_form": "стоимость", "base": "^стоимость$"}, {"main_form": "престиж", "base": "(^престиж$)|(^prestige$)"}, {"main_form": "горький", "base": "^горьк.+$"}, {"main_form": "малый", "base": "^малый$"}, {"main_form": "звезда", "base": "^звезд.$"}, {"main_form": "микроволновый", "base": "^микроволновый$"}, {"main_form": "печь", "base": "^печь$"}, {"main_form": "season", "base": "^season$"}, {"main_form": "антей", "base": "^антей$"}, {"main_form": "роскошный", "base": "^роскош.{1,4}$"}, {"main_form": "collection", "base": "^collection$"}, {"main_form": "тариф", "base": "^тариф$"}, {"main_form": "sky", "base": "^sky$"}, {"main_form": "охотничий", "base": "^охотн.{2,6}$"}, {"main_form": "эко", "base": "^эко$"}, {"main_form": "модус", "base": "^модус$"}, {"main_form": "канал", "base": "^канал$"}, {"main_form": "склон", "base": "^склон$"}, {"main_form": "летний", "base": "^лет.{1,4}$"}, {"main_form": "деревянный", "base": "^деревян.{1,4}$"}, {"main_form": "усадьба", "base": "^усадьба$"}, {"main_form": "магия", "base": "^магия$"}, {"main_form": "волга", "base": "^волга$"}, {"main_form": "местный", "base": "^х?местн.{0,2}$"}, {"main_form": "койка", "base": "^койк.$"}, {"main_form": "место", "base": "^место$"}, {"main_form": "подарок", "base": "^подарок$"}, {"main_form": "курорт", "base": "^курорт$"}, {"main_form": "фитнес", "base": "(^фитнес$)|(^fitness$)"}, {"main_form": "смарт", "base": "^смарт$"}, {"main_form": "бесплатный", "base": "^бесплатный$"}, {"main_form": "аромаванна", "base": "^аромаванна$"}, {"main_form": "уютный", "base": "(^уютный$)|(^cozy$)"}, {"main_form": "элитный", "base": "(^элитный$)|(^elite?$)"}]
semantic_map = [{"main_form": "одноместный", "base": "один местный"}, {"main_form": "двухместный", "base": "два местный"}, {"main_form": "трехместный", "base": "три местный"}, {"main_form": "четырехместный", "base": "четыре местный"}, {"main_form": "пятиместный", "base": "пять местный"}, {"main_form": "шестиместный", "base": "шесть местный"}, {"main_form": "семиместный", "base": "семь местный"}, {"main_form": "восьмиместный", "base": "восемь местный"}, {"main_form": "девятиместный", "base": "девять местный"}, {"main_form": "десятиместный", "base": "десять местный"}, {"main_form": "одиннадцатиместный", "base": "одиннадцать местный"}, {"main_form": "двенадцатиместный", "base": "двенадцать местный"}, {"main_form": "тринадцатиместный", "base": "тринадцать местный"}, {"main_form": "четырнадцатиместный", "base": "четырнадцать местный"}, {"main_form": "петнадцатиместный", "base": "петнадцать местный"}, {"main_form": "шестнадцатиместный", "base": "шестнадцать местный"}, {"main_form": "восемнадцатиместный", "base": "восемнадцать местный"}, {"main_form": "двадцатиместный", "base": "двадцать местный"}, {"main_form": "двадцатиодноместный", "base": "двадцатьодин местный"}, {"main_form": "двадцатидвухместный", "base": "двадцатьдва местный"}, {"main_form": "двадцатичетырехместный", "base": "двадцатьчетыре местный"}, {"main_form": "двадцатишестиместный", "base": "двадцатьшесть местный"}, {"main_form": "двадцативосьмиместный", "base": "двадцатьвосемь местный"}, {"main_form": "одноместный", "base": "один место"}, {"main_form": "двухместный", "base": "два место"}, {"main_form": "трехместный", "base": "три место"}, {"main_form": "четырехместный", "base": "четыре место"}, {"main_form": "пятиместный", "base": "пять место"}, {"main_form": "шестиместный", "base": "шесть место"}, {"main_form": "семиместный", "base": "семь место"}, {"main_form": "восьмиместный", "base": "восемь место"}, {"main_form": "девятиместный", "base": "девять место"}, {"main_form": "десятиместный", "base": "десять место"}, {"main_form": "одиннадцатиместный", "base": "одиннадцать место"}, {"main_form": "двенадцатиместный", "base": "двенадцать место"}, {"main_form": "тринадцатиместный", "base": "тринадцать место"}, {"main_form": "четырнадцатиместный", "base": "четырнадцать место"}, {"main_form": "петнадцатиместный", "base": "петнадцать место"}, {"main_form": "шестнадцатиместный", "base": "шестнадцать место"}, {"main_form": "восемнадцатиместный", "base": "восемнадцать место"}, {"main_form": "двадцатиместный", "base": "двадцать место"}, {"main_form": "двадцатиодноместный", "base": "двадцатьодин место"}, {"main_form": "двадцатидвухместный", "base": "двадцатьдва место"}, {"main_form": "двадцатичетырехместный", "base": "двадцатьчетыре место"}, {"main_form": "двадцатишестиместный", "base": "двадцатьшесть место"}, {"main_form": "двадцативосьмиместный", "base": "двадцатьвосемь место"}, {"main_form": "", "base": "advance saver rate"}, {"main_form": "", "base": "endless weekend rate"}, {"main_form": "", "base": "flexible rate"}, {"main_form": "", "base": "saver rate"}, {"main_form": "", "base": "event rate"}, {"main_form": "", "base": "advance saver bb"}, {"main_form": "", "base": "advance saver"}, {"main_form": "", "base": "saver hb"}, {"main_form": "", "base": "swissotel seasonal saver"}, {"main_form": "", "base": "saver"}, {"main_form": "", "base": "smart"}, {"main_form": "", "base": "park stay"}, {"main_form": "", "base": "stay long save"}, {"main_form": "", "base": "stay longer save"}, {"main_form": "", "base": "long stay"}, {"main_form": "", "base": "stay"}, {"main_form": "", "base": "swiss бизнес advantage"}, {"main_form": "", "base": "swiss advantage"}, {"main_form": "", "base": "b01st7 week on the проживание"}, {"main_form": "", "base": "p01hlf half board предложение"}, {"main_form": "", "base": "p01wkd endless проживание"}, {"main_form": "", "base": "p01kid kid комната проживание"}, {"main_form": "", "base": "romance"}, {"main_form": "", "base": "bb"}, {"main_form": "", "base": "супер распродажа 33.33"}, {"main_form": "", "base": "бизнес advantage"}, {"main_form": "однокомнатный", "base": "один комнатный"}, {"main_form": "двухкомнатный", "base": "два комнатный"}, {"main_form": "трехкомнатный", "base": "три комнатный"}, {"main_form": "четырехкомнатный", "base": "четыре комнатный"}, {"main_form": "делюкс", "base": "de люкс"}, {"main_form": "делюкс", "base": "де люкс"}, {"main_form": "wifi", "base": "wi fi"}, {"main_form": "двухспальный кровать", "base": "двуспальнойкровать"}, {"main_form": "king размер", "base": "кингсайз"}, {"main_form": "некурящий", "base": "не курящий"}]

import re

def apply_dict_to_word(word, dictionary):
    mathes = []
    for wordform in dictionary:
        if re.match(wordform['base'], word):
            mathes.append(wordform['main_form'])
            return True, wordform['main_form']
    if len(mathes) == 0:
        return False, word
    if len(mathes) == 1:
        return True, mathes[0]
    print(word, ' | '.join(mathes))
    assert False


def apply_semantic_map(sentence, semantic_map):
    sentence = ' ' .join(sentence)
    for item in semantic_map:
        if item['base'] in sentence or item['base'] in sentence:
            sentence = sentence.replace(item['base'], item['main_form'])
    return sentence.split(' ')


def weird_numerical_token(word):
    l = len(word)
    nl = len([item for item in word if item.isdigit()])
    if l - nl <= 1:
        return True
    return False


def process_sentence(sentence):
    if sentence is None or isinstance(sentence, float):
        return ""

    new_sentence = []
    sentence = sentence.replace('-', ' ')
    for word in sentence.split(' '):
        if word in stopwords:
            continue
        dict_word, form = apply_dict_to_word(word, dictionary)
        if not dict_word and not weird_numerical_token(word):
            continue
        if not dict_word and weird_numerical_token(word):
            continue
        new_sentence.append(form)
    new_sentence = list(sorted([item for item in apply_semantic_map(new_sentence, semantic_map) if item != '']))
    return " ".join(new_sentence)

def paired_word_difference(first, second):
    if first == second:
        return 1.
    if first is None or second is None:
        return 0.

    if isinstance(first, bytes):
        first = first.decode('utf-8')
    first = set(process_sentence(onlyletters(first.lower())).split(' '))

    if isinstance(second, bytes):
        second = second.decode('utf-8')
    second = set(process_sentence(onlyletters(second.lower())).split(' '))

    intersected = len(first.intersection(second))
    united = len(first.union(second))

    rating = 0
    if united != 0:
        rating += float(intersected) / ((len(first) * len(second)) ** (0.5))

    return rating
