import logging
from typing import Any, Dict

from travel.hotels.lib.python3.yt import ytlib

from travel.hotels.tools.dataset_curator.dataset_build_configuration import BuildContext
from travel.hotels.tools.dataset_curator.datasets.registry import get_registry_for_build

LOG = logging.getLogger(__name__)

registry = get_registry_for_build()


@registry.new_builder('hotel_places_nearby', versioned_process=True, create_latest=True)
def hotel_places_nearby_builder(ctx: BuildContext, args: Dict[str, Any]):
    ctx.run_yql_builder(
        'hotel_places_nearby/build_dists_to_center.yql',
        yql_params={
            '$output': ytlib.join(ctx.current_dataset_version_path, 'dists_to_center'),
        },
        sync=False
    )

    ctx.run_yql_builder(
        'hotel_places_nearby/build_dists_to_parks.yql',
        yql_params={
            '$output': ytlib.join(ctx.current_dataset_version_path, 'dists_to_parks'),
        },
        sync=False
    )

    ctx.run_yql_builder(
        'hotel_places_nearby/build_dists_to_airports.yql',
        yql_params={
            '$output': ytlib.join(ctx.current_dataset_version_path, 'dists_to_airports'),
        },
        sync=False
    )

    ctx.run_yql_builder(
        'hotel_places_nearby/build_dists_to_seas.yql',
        yql_params={
            '$output': ytlib.join(ctx.current_dataset_version_path, 'dists_to_seas'),
        },
        sync=False
    )

    ctx.wait_all_yql_reqs()
