import logging
from typing import Any, Dict

from travel.hotels.tools.dataset_curator.dataset_build_configuration import BuildContext
from travel.hotels.tools.dataset_curator.datasets.marketing_feeds.wizard_hotel_names_parser import WizardHotelNamesParser
from travel.hotels.tools.dataset_curator.datasets.registry import get_registry_for_build

LOG = logging.getLogger(__name__)

registry = get_registry_for_build()


@registry.new_builder('marketing_parsed_hotel_names', versioned_process=True, create_latest=True)
def ranking_factors_builder(ctx: BuildContext, args: Dict[str, Any]):
    def get_int(name, default=None):
        if name in args:
            return int(args[name])
        return default

    parser = WizardHotelNamesParser(
        ctx.yt_client,
        args['feed_path'],
        ctx.current_dataset_version_path,
        args.get('wizard_url', 'http://addrs-testing.search.yandex.net/wizard/stable/wizard'),
        get_int('max_rps', 5),
        get_int('tries_limit', 3),
        get_int('max_failed_records', 100),
        get_int('records_limit', None)
    )
    parser.run()
