$list_median = ($list) -> (ListSort($list)[ListLength($list) / 2]);

$raw_ema = Python3::ema(@@
from yql.typing import *

def ema(data: List[Optional[Double]], ndays: Uint32, default_value: Optional[Double]) -> Optional[Double]:
    alpha = 2 / (ndays + 1)
    res = None
    last_not_none = None
    for x in data:
        if x is not None:
            last_not_none = x
        if last_not_none is not None:
            if res is None:
                res = last_not_none
            else:
                res = alpha * last_not_none + (1 - alpha) * res
    if res is None:
        return default_value
    return res
@@);

$ema_factory = ($ema_ndays, $to_date, $date_field_name) -> {
    RETURN ($list, $field, $default) -> {
        $dates = ListMap(ListFromRange(-$ema_ndays + 1, 1), ($x) -> ($to_date + DateTime::IntervalFromDays($x)));
        $mapping = ToDict(ListFilter(ListMap($list, ($x) -> ((Unwrap(TryMember($x, $date_field_name, NULL), "Null value of " || $date_field_name), TryMember($x, $field, NULL)))), ($x) -> ($x.1 IS NOT NULL)));

        $filled_data = ListMap($dates, ($x) -> (CAST(DictLookup($mapping, $x) AS Double) ?? Nothing(Double?)));

        RETURN $raw_ema($filled_data, $ema_ndays, $default);
    };
};

$yt_path_dirname = ($path) -> {
    $parts = String::SplitToList($path, "/");
    return Unwrap($parts[ListLength($parts) - 2]);
};

EXPORT $list_median, $ema_factory, $yt_path_dirname;
