import logging

from typing import Any, Dict

from travel.hotels.lib.python3.yt import ytlib

from travel.hotels.tools.dataset_curator.dataset_build_configuration import BuildContext
from travel.hotels.tools.dataset_curator.datasets.registry import get_registry_for_build

LOG = logging.getLogger(__name__)

registry = get_registry_for_build()


@registry.new_builder('ranking_factors', versioned_process=True, create_latest=True)
def ranking_factors_builder(ctx: BuildContext, args: Dict[str, Any]):
    old_factors_path = str(ytlib.join(ctx.current_dataset_version_path, 'old_factors'))

    ctx.run_yql_builder(
        'ranking_factors/old_factors_builder.yql',
        yql_params={
            '$output': old_factors_path,
        }
    )

    ctx.run_yql_builder(
        'ranking_factors/ranking_factors_builder.yql',
        yql_params={
            '$old_factors': old_factors_path,
            '$factors_experimental_output': str(ytlib.join(ctx.current_dataset_version_path, 'factors_experimental')),
        }
    )

    ctx.run_yql_builder(
        'ranking_factors/features_builder.yql',
        yql_params={
            '$features_output': str(ytlib.join(ctx.current_dataset_version_path, 'hotel_features')),
        }
    )


@registry.new_builder('geosearch_factors_export', versioned_process=True, create_latest=True)
def geosearch_factors_export_builder(ctx: BuildContext, args: Dict[str, Any]):
    ctx.run_yql_builder(
        'ranking_factors/copy_to_geosearch.yql',
        yql_params={
            '$output': str(ytlib.join(ctx.current_dataset_version_path, 'output')),
            '$ranking_factors_path': '//home/travel/prod/datasets/ranking_factors/latest/factors_experimental',
            '$experimental_factors_path': '//home/travel/prod/factors/experimental/latest',
        }
    )
