$hotel_distance = "//home/travel/prod/general/hotels_neighborhood/latest";

DEFINE SUBQUERY $build_redirects_features($build_redirects) AS
    $bookings_data = (
        SELECT
            sum_redirects,
            avg_redirects,
            permalink
        FROM $build_redirects()
    );

    $permalinks_data = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            distance
        FROM $hotel_distance AS base
        INNER JOIN $bookings_data AS book
        USING (permalink)
    );

    $joined = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            IF(distance < 1, 1, IF(distance < 5, 0.5, 0.1)) AS distance,
            sum_redirects,
            avg_redirects,
        FROM $permalinks_data AS base
        LEFT JOIN $bookings_data AS bookings
        ON (base.neighbour_permalink == bookings.permalink)
    );

    $grouped = (
        SELECT
            permalink,
            COUNT(*) AS counts,
            SUM_IF(sum_redirects, permalink == neighbour_permalink) AS base_sum_redirects,
            SUM_IF(avg_redirects, permalink == neighbour_permalink) AS base_avg_redirects,
            IF(COUNT_IF(sum_redirects IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_redirects * distance) / SUM_IF(distance, sum_redirects IS NOT NULL), -1) AS neigh_sum_redirects,
            IF(COUNT_IF(avg_redirects IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_redirects * distance) / SUM_IF(distance, avg_redirects IS NOT NULL), -1) AS neigh_avg_redirects,
        FROM $joined
        WHERE permalink IS NOT NULL
        GROUP BY (permalink)
    );

    SELECT
        permalink,
        base_sum_redirects AS sum_redirects,
        base_avg_redirects AS avg_redirects,
        IF(base_sum_redirects / neigh_sum_redirects ?? 1 > 0, base_sum_redirects / neigh_sum_redirects ?? 1, -1) AS rel_sum_redirects,
        IF(base_avg_redirects / neigh_avg_redirects ?? 1 > 0, base_avg_redirects / neigh_avg_redirects ?? 1, -1) AS rel_avg_redirects
    FROM $grouped
END DEFINE;

DEFINE SUBQUERY $build_partners_features($build_partners) AS
    $bookings_data = (
        SELECT
            avg_bookings,
            sum_bookings,
            sum_hits,
            avg_hits,
            permalink
        FROM $build_partners()
    );

    $permalinks_data = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            distance
        FROM $hotel_distance AS base
        INNER JOIN $bookings_data AS book
        USING (permalink)
    );

    $joined = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            IF(distance < 1, 1, IF(distance < 5, 0.5, 0.1)) AS distance,
            avg_bookings,
            sum_bookings,
            sum_hits,
            avg_hits,
        FROM $permalinks_data AS base
        LEFT JOIN $bookings_data AS bookings
        ON (base.neighbour_permalink == bookings.permalink)
    );

    $grouped = (
        SELECT
            permalink,
            COUNT(*) AS counts,
            SUM_IF(avg_bookings, permalink == neighbour_permalink) AS base_avg_bookings,
            SUM_IF(sum_bookings, permalink == neighbour_permalink) AS base_sum_bookings,
            SUM_IF(sum_hits, permalink == neighbour_permalink) AS base_sum_hits,
            SUM_IF(avg_hits, permalink == neighbour_permalink) AS base_avg_hits,
            IF(COUNT_IF(avg_bookings IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_bookings * distance) / SUM_IF(distance, avg_bookings IS NOT NULL), -1) AS neigh_avg_bookings,
            IF(COUNT_IF(sum_bookings IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_bookings * distance) / SUM_IF(distance, sum_bookings IS NOT NULL), -1) AS neigh_sum_bookings,
            IF(COUNT_IF(sum_hits IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_hits * distance) / SUM_IF(distance, sum_hits IS NOT NULL), -1) AS neigh_sum_hits,
            IF(COUNT_IF(avg_hits IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_hits * distance) / SUM_IF(distance, avg_hits IS NOT NULL), -1) AS neigh_avg_hits,
        FROM $joined
        WHERE permalink IS NOT NULL
        GROUP BY (permalink)
    );

    SELECT
        permalink,
        base_avg_bookings AS avg_bookings,
        base_sum_bookings AS sum_bookings,
        base_sum_hits AS sum_hits,
        base_avg_hits AS avg_hits,
        IF(base_avg_bookings / neigh_avg_bookings ?? 1 > 0, base_avg_bookings / neigh_avg_bookings ?? 1, -1) AS rel_avg_bookings,
        IF(base_sum_bookings / neigh_sum_bookings ?? 1 > 0, base_sum_bookings / neigh_sum_bookings ?? 1, -1) AS rel_sum_bookings,
        IF(base_sum_hits / neigh_sum_hits ?? 1 > 0, base_sum_hits / neigh_sum_hits ?? 1, -1) AS rel_sum_hits,
        IF(base_avg_hits / neigh_avg_hits ?? 1 > 0, base_avg_hits / neigh_avg_hits ?? 1, -1) AS rel_avg_hits,
    FROM $grouped
END DEFINE;

DEFINE SUBQUERY $build_singleorg_features($build_singleorg) AS
    $bookings_data = (
        SELECT
            sum_shows,
            avg_shows,
            sum_clicks,
            avg_clicks,
            permalink
        FROM $build_singleorg()
    );

    $permalinks_data = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            distance
        FROM $hotel_distance AS base
        INNER JOIN $bookings_data AS book
        USING (permalink)
    );

    $joined = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            IF(distance < 1, 1, IF(distance < 5, 0.5, 0.1)) AS distance,
            sum_shows,
            avg_shows,
            sum_clicks,
            avg_clicks,
        FROM $permalinks_data AS base
        LEFT JOIN $bookings_data AS bookings
        ON (base.neighbour_permalink == bookings.permalink)
    );

    $grouped = (
        SELECT
            permalink,
            COUNT(*) AS counts,
            SUM_IF(sum_shows, permalink == neighbour_permalink) AS base_sum_shows,
            SUM_IF(avg_shows, permalink == neighbour_permalink) AS base_avg_shows,
            SUM_IF(sum_clicks, permalink == neighbour_permalink) AS base_sum_clicks,
            SUM_IF(avg_clicks, permalink == neighbour_permalink) AS base_avg_clicks,
            IF(COUNT_IF(sum_shows IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_shows * distance) / SUM_IF(distance, sum_shows IS NOT NULL), -1) AS neigh_sum_shows,
            IF(COUNT_IF(avg_shows IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_shows * distance) / SUM_IF(distance, avg_shows IS NOT NULL), -1) AS neigh_avg_shows,
            IF(COUNT_IF(sum_clicks IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_clicks * distance) / SUM_IF(distance, sum_clicks IS NOT NULL), -1) AS neigh_sum_clicks,
            IF(COUNT_IF(avg_clicks IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_clicks * distance) / SUM_IF(distance, avg_clicks IS NOT NULL), -1) AS neigh_avg_clicks,
        FROM $joined
        WHERE permalink IS NOT NULL
        GROUP BY (permalink)
    );

    SELECT
        permalink,
        base_sum_shows AS sum_shows,
        base_avg_shows AS avg_shows,
        base_sum_clicks AS sum_clicks,
        base_avg_clicks AS avg_clicks,
        IF(base_sum_shows / neigh_sum_shows ?? 1 > 0, base_sum_shows / neigh_sum_shows ?? 1, -1) AS rel_sum_shows,
        IF(base_avg_shows / neigh_avg_shows ?? 1 > 0, base_avg_shows / neigh_avg_shows ?? 1, -1) AS rel_avg_shows,
        IF(base_sum_clicks / neigh_sum_clicks ?? 1 > 0, base_sum_clicks / neigh_sum_clicks ?? 1, -1) AS rel_sum_clicks,
        IF(base_avg_clicks / neigh_avg_clicks ?? 1 > 0, base_avg_clicks / neigh_avg_clicks ?? 1, -1) AS rel_avg_clicks,
    FROM $grouped
END DEFINE;

DEFINE SUBQUERY $build_multiorg_features($build_carousel) AS
    $bookings_data = (
        SELECT
            sum_shows,
            avg_shows,
            sum_clicks,
            avg_clicks,
            sum_last_click,
            avg_last_click,
            permalink
        FROM $build_carousel()
    );

    $permalinks_data = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            distance
        FROM $hotel_distance AS base
        INNER JOIN $bookings_data AS book
        USING (permalink)
    );

    $joined = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            IF(distance < 1, 1, IF(distance < 5, 0.5, 0.1)) AS distance,
            sum_shows,
            avg_shows,
            sum_clicks,
            avg_clicks,
            sum_last_click,
            avg_last_click,
        FROM $permalinks_data AS base
        LEFT JOIN $bookings_data AS bookings
        ON (base.neighbour_permalink == bookings.permalink)
    );

    $grouped = (
        SELECT
            permalink,
            COUNT(*) AS counts,
            SUM_IF(sum_shows, permalink == neighbour_permalink) AS base_sum_shows,
            SUM_IF(avg_shows, permalink == neighbour_permalink) AS base_avg_shows,
            SUM_IF(sum_clicks, permalink == neighbour_permalink) AS base_sum_clicks,
            SUM_IF(avg_clicks, permalink == neighbour_permalink) AS base_avg_clicks,
            SUM_IF(sum_last_click, permalink == neighbour_permalink) AS base_sum_last_click,
            SUM_IF(avg_last_click, permalink == neighbour_permalink) AS base_avg_last_click,
            IF(COUNT_IF(sum_shows IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_shows * distance) / SUM_IF(distance, sum_shows IS NOT NULL), -1) AS neigh_sum_shows,
            IF(COUNT_IF(avg_shows IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_shows * distance) / SUM_IF(distance, avg_shows IS NOT NULL), -1) AS neigh_avg_shows,
            IF(COUNT_IF(sum_clicks IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_clicks * distance) / SUM_IF(distance, sum_clicks IS NOT NULL), -1) AS neigh_sum_clicks,
            IF(COUNT_IF(avg_clicks IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_clicks * distance) / SUM_IF(distance, avg_clicks IS NOT NULL), -1) AS neigh_avg_clicks,
            IF(COUNT_IF(sum_last_click IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(sum_last_click * distance) / SUM_IF(distance, sum_last_click IS NOT NULL), -1) AS neigh_sum_last_click,
            IF(COUNT_IF(avg_last_click IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_last_click * distance) / SUM_IF(distance, avg_last_click IS NOT NULL), -1) AS neigh_avg_last_click,
        FROM $joined
        WHERE permalink IS NOT NULL
        GROUP BY (permalink)
    );

    SELECT
        permalink,
        base_sum_shows AS sum_shows,
        base_avg_shows AS avg_shows,
        base_sum_clicks AS sum_clicks,
        base_avg_clicks AS avg_clicks,
        base_sum_last_click AS sum_last_click,
        base_avg_last_click AS avg_last_click,
        IF(base_sum_shows / neigh_sum_shows ?? 1 > 0, base_sum_shows / neigh_sum_shows ?? 1, -1) AS rel_sum_shows,
        IF(base_avg_shows / neigh_avg_shows ?? 1 > 0, base_avg_shows / neigh_avg_shows ?? 1, -1) AS rel_avg_shows,
        IF(base_sum_clicks / neigh_sum_clicks ?? 1 > 0, base_sum_clicks / neigh_sum_clicks ?? 1, -1) AS rel_sum_clicks,
        IF(base_avg_clicks / neigh_avg_clicks ?? 1 > 0, base_avg_clicks / neigh_avg_clicks ?? 1, -1) AS rel_avg_clicks,
        IF(base_sum_last_click / neigh_sum_last_click ?? 1 > 0, base_sum_last_click / neigh_sum_last_click ?? 1, -1) AS rel_sum_last_click,
        IF(base_avg_last_click / neigh_avg_last_click ?? 1 > 0, base_avg_last_click / neigh_avg_last_click ?? 1, -1) AS rel_avg_last_click,
    FROM $grouped
END DEFINE;

DEFINE SUBQUERY $build_booking_features($build_bookings) AS
    $bookings_data = (
        SELECT
            bookings,
            avg_order,
            permalink
        FROM $build_bookings()
    );

    $permalinks_data = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            distance
        FROM $hotel_distance AS base
        INNER JOIN $bookings_data AS book
        USING (permalink)
    );

    $joined = (
        SELECT
            base.permalink AS permalink,
            neighbour_permalink,
            IF(distance < 1, 1, IF(distance < 5, 0.5, 0.1)) AS distance,
            avg_order,
            bookings
        FROM $permalinks_data AS base
        LEFT JOIN $bookings_data AS bookings
        ON (base.neighbour_permalink == bookings.permalink)
    );

    $grouped = (
        SELECT
            permalink,
            COUNT(*) AS counts,
            SUM_IF(avg_order, permalink == neighbour_permalink) AS base_avg_order,
            SUM_IF(bookings, permalink == neighbour_permalink) AS base_bookings,
            IF(COUNT_IF(avg_order IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(avg_order * distance) / SUM_IF(distance, avg_order IS NOT NULL), -1) AS neigh_avg_order,
            IF(COUNT_IF(bookings IS NOT NULL) > 2 AND COUNT(*) > 2, SUM(bookings * distance) / SUM_IF(distance, bookings IS NOT NULL), -1) AS neigh_bookings,
        FROM $joined
        WHERE permalink IS NOT NULL
        GROUP BY (permalink)
    );

    SELECT
        permalink,
        base_avg_order AS avg_order,
        base_bookings AS bookings,
        IF(base_avg_order / neigh_avg_order ?? 1 > 0, base_avg_order / neigh_avg_order ?? 1, -1) AS rel_avg_order,
        IF(base_bookings / neigh_bookings ?? 1 > 0, base_bookings / neigh_bookings ?? 1, -1) AS rel_bookings
    FROM $grouped
END DEFINE;

EXPORT $build_redirects_features, $build_partners_features, $build_singleorg_features, $build_multiorg_features, $build_booking_features;
