import logging

from travel.hotels.tools.dataset_curator.dataset_build_configuration import BuildersRegistry

LOG = logging.getLogger(__name__)

_registry = BuildersRegistry()


def get_registry_for_build():
    return _registry


def get_registry_for_use():
    # noinspection PyUnresolvedReferences
    import travel.hotels.tools.dataset_curator.datasets.prices_and_availabilities.builders  # noqa: F401
    # noinspection PyUnresolvedReferences
    import travel.hotels.tools.dataset_curator.datasets.ranking_factors.builders  # noqa: F401
    # noinspection PyUnresolvedReferences
    import travel.hotels.tools.dataset_curator.datasets.marketing_feeds.builders  # noqa: F401
    # noinspection PyUnresolvedReferences
    import travel.hotels.tools.dataset_curator.datasets.hotel_places_nearby.builders  # noqa: F401

    return _registry
