# -*- coding: utf-8 -*-

from yt.wrapper import YtClient

from travel.hotels.lib.python3.yt import ytlib
from travel.hotels.lib.python3.cli.cli import log_progress_reporter


def list_recursive(yt_client, path):
    res = []
    for child in yt_client.list(path, attributes=['type']):
        node_type = child.attributes['type']
        if node_type == 'table':
            res.append(str(child))
        elif node_type == 'map_node':
            res += [f'{child}/{x}' for x in list_recursive(yt_client, str(ytlib.join(path, str(child))))]
        else:
            raise Exception(f'Unknown node type: {node_type}')
    return res


def read_yt_table_with_progress(yt_client: YtClient, table_path: str):
    return log_progress_reporter(yt_client.read_table(table_path), f'Processing {table_path}', total=yt_client.row_count(table_path))
