PY3_PROGRAM()

OWNER(g:travel-hotels)

PY_SRCS(
    datasets/registry.py
    datasets/hotel_places_nearby/builders.py
    datasets/prices_and_availabilities/builders.py
    datasets/ranking_factors/builders.py
    datasets/marketing_feeds/builders.py
    datasets/marketing_feeds/wizard_hotel_names_parser.py

    __main__.py
    auto_build_context_creator.py
    config_parsing.py
    data.py
    dataset_build_configuration.py
    dataset_building.py
    dataset_cleanup.py
    sb_planner_plan_builder.py
    schedules.py
    tools.py
    type_schemas.py
    validation_results.py
    validation_running.py
    validators.py
    yt_storage.py
)

PEERDIR(
    travel/library/python/tools
    travel/library/python/arcadia
    travel/hotels/lib/python3/yt
    travel/hotels/lib/python3/yql
    travel/hotels/lib/python3/cli
    travel/hotels/lib/python3/utils

    yt/python/client
    yql/library/python

    contrib/python/PyYAML
)

RESOURCE(
    datasets/types.yaml types.yaml

    # bronevik
    datasets/bronevik/datasets.yaml bronevik/datasets.yaml
    datasets/bronevik/queries/hotel_timezone.yql bronevik/hotel_timezone.yql

    # catroom
    datasets/catroom/datasets.yaml catroom/datasets.yaml
    datasets/catroom/queries/build_catroom_learning_data.yql catroom/build_catroom_learning_data.yql
    datasets/catroom/queries/build_enriched_permarooms.yql catroom/build_enriched_permarooms.yql
    datasets/catroom/queries/build_matching.yql catroom/build_matching.yql
    datasets/catroom/queries/convert_room_name_to_useful.py catroom/convert_room_name_to_useful.py
    datasets/catroom/queries/paired_word_difference.py catroom/paired_word_difference.py

    # datalense
    datasets/datalense/datasets.yaml datalense/datasets.yaml
    datasets/datalense/queries/build_hotels_search_load_times.yql datalense/build_hotels_search_load_times.yql

    # hotel_places_nearby
    datasets/hotel_places_nearby/datasets.yaml hotel_places_nearby/datasets.yaml
    datasets/hotel_places_nearby/queries/build_dists_to_airports.yql hotel_places_nearby/build_dists_to_airports.yql
    datasets/hotel_places_nearby/queries/build_dists_to_center.yql hotel_places_nearby/build_dists_to_center.yql
    datasets/hotel_places_nearby/queries/build_dists_to_parks.yql hotel_places_nearby/build_dists_to_parks.yql
    datasets/hotel_places_nearby/queries/build_dists_to_seas.yql hotel_places_nearby/build_dists_to_seas.yql
    datasets/hotel_places_nearby/queries/lib.sql hotel_places_nearby/lib.sql

    # prices_and_availabilities
    datasets/prices_and_availabilities/datasets.yaml prices_and_availabilities/datasets.yaml
    datasets/prices_and_availabilities/queries/lib.sql prices_and_availabilities/lib.sql
    datasets/prices_and_availabilities/queries/build_aggr_hotel_id_per_night_prices.yql prices_and_availabilities/build_aggr_hotel_id_per_night_prices.yql
    datasets/prices_and_availabilities/queries/build_cluster_permalink_availabilities.yql prices_and_availabilities/build_cluster_permalink_availabilities.yql
    datasets/prices_and_availabilities/queries/build_cluster_permalink_per_night_prices.yql prices_and_availabilities/build_cluster_permalink_per_night_prices.yql
    datasets/prices_and_availabilities/queries/build_cluster_permalink_prices.yql prices_and_availabilities/build_cluster_permalink_prices.yql
    datasets/prices_and_availabilities/queries/build_hotel_id_availabilities.yql prices_and_availabilities/build_hotel_id_availabilities.yql
    datasets/prices_and_availabilities/queries/build_partner_id_original_id_observed_prices.yql prices_and_availabilities/build_partner_id_original_id_observed_prices.yql
    datasets/prices_and_availabilities/queries/build_partner_id_original_id_per_night_prices.yql prices_and_availabilities/build_partner_id_original_id_per_night_prices.yql
    datasets/prices_and_availabilities/queries/build_price_filter_data.yql prices_and_availabilities/build_price_filter_data.yql
    datasets/prices_and_availabilities/queries/build_regions_prices.yql prices_and_availabilities/build_regions_prices.yql
    datasets/prices_and_availabilities/queries/build_regions_counters.yql prices_and_availabilities/build_regions_counters.yql

    # other
    datasets/other/datasets.yaml other/datasets.yaml

    # ranking_factors
    datasets/ranking_factors/datasets.yaml ranking_factors/datasets.yaml
    datasets/ranking_factors/queries/lib.sql ranking_factors/lib.sql
    datasets/ranking_factors/queries/features_builder_lib.sql ranking_factors/features_builder_lib.sql
    datasets/ranking_factors/queries/old_factors_builder.yql ranking_factors/old_factors_builder.yql
    datasets/ranking_factors/queries/features_builder.yql ranking_factors/features_builder.yql
    datasets/ranking_factors/queries/ranking_factors_builder.yql ranking_factors/ranking_factors_builder.yql
    datasets/ranking_factors/queries/copy_to_geosearch.yql ranking_factors/copy_to_geosearch.yql

    # marketing_feeds
    datasets/marketing_feeds/datasets.yaml marketing_feeds/datasets.yaml

    # rasp_dicts
    datasets/rasp_dicts/datasets.yaml rasp_dicts/datasets.yaml

    # portal_logs
    datasets/portal_logs/datasets.yaml portal_logs/datasets.yaml
    datasets/portal_logs/queries/build_hotel_page_logs.yql portal_logs/build_hotel_page_logs.yql

    # permaroom_moderation
    datasets/permaroom_moderation/datasets.yaml permaroom_moderation/datasets.yaml
    datasets/permaroom_moderation/queries/build_data_for_moderation.yql permaroom_moderation/build_data_for_moderation.yql

    # permaroom_moderation
    datasets/altay/datasets.yaml altay/datasets.yaml
    datasets/altay/queries/build_altay_signals_info.yql altay/build_altay_signals_info.yql
    datasets/altay/queries/build_direct_boy_altay_publish_info.yql altay/build_direct_boy_altay_publish_info.yql
    datasets/altay/queries/build_direct_boy_feed_signals_info.yql altay/build_direct_boy_feed_signals_info.yql

    # expedia
    datasets/expedia/datasets.yaml expedia/datasets.yaml
    datasets/expedia/queries/hotel_coordinates.yql expedia/hotel_coordinates.yql

    # dolphin
    datasets/dolphin/datasets.yaml dolphin/datasets.yaml
    datasets/dolphin/queries/hotel_coordinates.yql dolphin/hotel_coordinates.yql
)

END()

