package ru.yandex.travel.gen_logfeller_parser_pojo.generator;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;


public class Main {

    private static final String BINARY_NAME = " ";

    public static void main(String[] args) throws Exception {

        final Options options = new Options();
        options.addOption(Option.builder()
                .longOpt("class")
                .argName("FULL CLASS NAME")
                .hasArgs()
                .required()
                .build()
        );
        options.addOption(Option.builder()
                .longOpt("out-file")
                .argName("OUTPUT FILE PATH")
                .hasArgs()
                .required()
                .build()
        );

        final HelpFormatter helpFormatter = new HelpFormatter();

        CommandLine cmd;
        try {
            cmd = new DefaultParser().parse(options, args);
        } catch (ParseException e) {
            helpFormatter.printHelp(BINARY_NAME, options);
            throw e;
        }

        if (cmd.hasOption("help")) {
            helpFormatter.printHelp(BINARY_NAME, options);
            return;
        }

        final Class<?> clazz = Class.forName(cmd.getOptionValue("class"), true, Main.class.getClassLoader());

        final Path jsonParserConfigFile = Paths.get(cmd.getOptionValue("out-file"));
        final Path directory = jsonParserConfigFile.getParent();
        Files.createDirectories(directory);
        Files.write(
                jsonParserConfigFile,
                JsonParserConfigBuilder.toJsonString(clazz).getBytes(),
                StandardOpenOption.WRITE,
                StandardOpenOption.TRUNCATE_EXISTING,
                StandardOpenOption.CREATE
        );

        System.out.println(String.format("File '%s' with JSON parser config was updated.", jsonParserConfigFile));
    }
}
