package ru.yandex.travel.gen_logfeller_parser_pojo.get_schema;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {

    private static final String BINARY_NAME = " ";

    public static void main(String[] args) throws Exception {

        final Options options = new Options();
        options.addOption(Option.builder()
                .longOpt("log")
                .argName("LOG NAME")
                .hasArg()
                .required()
                .build()
        );

        options.addOption(Option.builder()
                .longOpt("out-file")
                .argName("PATH TO OUT FILE")
                .hasArg()
                .required()
                .build()
        );

        final HelpFormatter helpFormatter = new HelpFormatter();

        CommandLine cmd;
        try {
            cmd = new DefaultParser().parse(options, args);
        } catch (ParseException e) {
            helpFormatter.printHelp(BINARY_NAME, options);
            throw e;
        }

        if (cmd.hasOption("help")) {
            helpFormatter.printHelp(BINARY_NAME, options);
            return;
        }

        final String logName = cmd.getOptionValue("log");
        final InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(logName);
        if(Objects.isNull(stream)) {
            throw new IllegalArgumentException(String.format("Log with name %s not found", logName));
        }

        final Path outFile = Paths.get(cmd.getOptionValue("out-file"));
        Files.copy(stream, outFile, StandardCopyOption.REPLACE_EXISTING);
    }
}
