JAVA_PROGRAM()

JDK_VERSION(11)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

PEERDIR(
    contrib/java/commons-cli/commons-cli
)

RUN_JAVA_PROGRAM(
    ru.yandex.travel.gen_logfeller_parser_pojo.generator.Main
    --class ru.yandex.travel.api.services.orders.happy_page.model.HappyPageLogRecord
    --out-file ${BINDIR}/generated/travel/api/hotels-happy-page-log
    OUT_DIR ${BINDIR}/generated
    CLASSPATH travel/hotels/tools/gen_logfeller_parser_pojo/generator
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/simple-runner.template.py
    CUSTOM_PROPERTY appName gen_logfeller_parser_pojo-get_schema
    CUSTOM_PROPERTY mainClass ru.yandex.travel.gen_logfeller_parser_pojo.get_schema.Main
    OUT get_schema.py
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/commons-cli/commons-cli/1.4
)

LINT(base)
END()
