package ru.yandex.travel.gen_logfeller_parser_pojo.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.travel.gen_logfeller_parser_pojo.model.FieldDemand;
import ru.yandex.travel.gen_logfeller_parser_pojo.model.FieldType;


/**
 * Redefine type, name of column or make field required.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface LogfellerConfig {
    /**
     * Is field required or optional.
     */
    FieldDemand demand() default FieldDemand.DEFAULT;

    /**
     * Column name. By default path will be substituted.
     */
    String name() default "";

    /**
     * Column type
     */
    FieldType type() default FieldType.AUTO;
}
