package ru.yandex.travel.hotels.tools

import org.apache.commons.cli.DefaultParser
import org.apache.commons.cli.Option
import org.apache.commons.cli.Options
import org.jooq.codegen.GenerationTool
import java.nio.file.Files
import java.nio.file.Path
import java.nio.file.Paths

class JooqGenerationTool {

    companion object {
        @JvmStatic
        fun getArcadiaRoot(initialPath: Path): Path {
            var currPath = initialPath.toAbsolutePath()
            while (true) {
                if (Files.exists(currPath.resolve(".arcadia.root"))) {
                    return currPath
                }
                if (currPath == currPath.root) {
                    throw Exception("Can't find arcadia root from path $initialPath")
                }
                currPath = currPath.parent
            }
        }

        @JvmStatic
        fun main(args: Array<String>) {
            val optionConfigPath = Option.builder("c")
                .desc("Config path")
                .longOpt("config-path")
                .required()
                .hasArg()
                .build()
            val optionDBUrl = Option.builder("U")
                .desc("DB Url")
                .longOpt("url")
                .hasArg()
                .build()
            val optionDBUser = Option.builder("u")
                .desc("DB User")
                .longOpt("user")
                .hasArg()
                .build()
            val optionDBPassword = Option.builder("p")
                .desc("DB Password")
                .longOpt("pass")
                .hasArg()
                .build()
            val options = Options()
                .addOption(optionConfigPath)
                .addOption(optionDBUrl)
                .addOption(optionDBUser)
                .addOption(optionDBPassword)
            val commandLine = DefaultParser().parse(options, args)

            val configPath = commandLine.getOptionValue(optionConfigPath.opt)
            val configuration = GenerationTool.load(Files.newInputStream(Path.of(configPath)))
            if (commandLine.hasOption(optionDBUrl.opt)) {
                configuration.jdbc.url = commandLine.getOptionValue(optionDBUrl.opt)
            }

            if (commandLine.hasOption(optionDBUser.opt)) {
                configuration.jdbc.user = commandLine.getOptionValue(optionDBUser.opt)
            }

            if (commandLine.hasOption(optionDBPassword.opt)) {
                configuration.jdbc.password = commandLine.getOptionValue(optionDBPassword.opt)
            }

            val arcadiaRoot = getArcadiaRoot(Paths.get(configPath))
            if (configuration?.generator?.target?.directory != null) {
                configuration.generator.target.directory =
                    arcadiaRoot.resolve(configuration.generator.target.directory).toString()
            }

            GenerationTool.generate(configuration)
        }
    }

}
