# encoding: utf-8

import json
import argparse

from yt.wrapper import YtClient


def iterate_data(filename):
    for line in open(filename):
        data = json.loads(line)
        permalink_str = data.get('permalink')
        travel_ids = set(data['travel_ids'])
        travel_ids.add(data['id'])
        row = {
            'rating': data['rating'],
            'permalink': int(permalink_str) if permalink_str else None,
            'name': data['name'],
            'country': data['country'],
            'image': data['image'],
            'travel_ids': list(travel_ids),
            'stars': data['stars'],
            'address': data['address'],
            'median_price': data['median_price'],
        }
        yield row


def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('--yt-token-path')
    parser.add_argument('--yt-token')
    parser.add_argument('--input-file', default='tmp/output.json')
    parser.add_argument('--output-table', required=True)

    args = parser.parse_args()

    yt_client = YtClient(proxy='hahn', config={
        'token_path': args.yt_token_path,
        'token': args.yt_token,
    })
    schema = [
        {'name': 'rating', 'type': 'double'},
        {'name': 'permalink', 'type': 'uint64'},
        {'name': 'name', 'type': 'string'},
        {'name': 'country', 'type': 'string'},
        {'name': 'image', 'type': 'string'},
        {'name': 'travel_ids', 'type': 'any'},
        {'name': 'stars', 'type': 'uint64'},
        {'name': 'address', 'type': 'string'},
        {'name': 'median_price', 'type': 'double'},
    ]
    if yt_client.exists(args.output_table):
        yt_client.remove(args.output_table)
    yt_client.create('table', args.output_table, attributes={'schema': schema})
    yt_client.write_table(args.output_table, iterate_data(args.input_file))


if __name__ == '__main__':
    main()
