$region_pages_renderer_results = "//home/travel/prod/general/region_pages/renderer/latest/result";
$geobase_table = "//home/geotargeting/public/geobase/regions";
$region_slugs = "//home/travel/prod/general/slugs/latest/region_slugs_export";
$region_images = "//home/travel/prod/config/region_images";
$permalink_to_hotel_info = "//home/travel/prod/general/altay_mappings/latest/permalink_to_hotel_info";
$hotel_id_to_permalink = "//home/travel/prod/general/altay_mappings/latest/partnerid_originalid_to_cluster_permalink";
$cluster_permalink_availabilities = "//home/travel/prod/datasets/aggregated_availabilities/latest/cluster_permalink_availabilities";
$permalink_to_cluster_mapping = "//home/travel/prod/general/altay_mappings/latest/permalink_to_cluster_permalink";
$cpa_orders = "//home/travel/prod/cpa/hotels/orders";
$wizards = "//home/geo-search/wizards_squeeze/daily/wizards";

$default_image_url = "https://yastatic.net/s3/travel-indexer/other/default_hotel_image.jpg";

DEFINE SUBQUERY $get_geo_ids($region_queries_from, $region_queries_to) AS
    $raw_geo_ids = (
        SELECT
            `reg_id` AS geo_id,
            FALSE AS has_seo_page,
            NULL AS seo_page_filter_slug,
        FROM $geobase_table
        WHERE
            `country_id` == 225 -- RU
            AND `type` == 6 -- city
        UNION ALL
        SELECT
            `geo_id`,
            TRUE AS has_seo_page,
            `filter_slug` AS seo_page_filter_slug,
        FROM $region_pages_renderer_results
    );

    $geo_ids = (
        SELECT
            `geo_id` AS GeoId,
            BOOL_OR(`has_seo_page`) AS HasSeoPage,
            ListFilter(AGGREGATE_LIST_DISTINCT(`seo_page_filter_slug`), ($x) -> ($x IS NOT NULL)) AS SeoPageFilterSlugs,
        FROM $raw_geo_ids
        GROUP BY geo_id
    );

    $region_popularity = (
        SELECT
            geoId AS GeoId,
            popularity AS Popularity,
        FROM `//home/travel/prod/adhoc_region_popularities`
    );

    $regions_prepositional_case = (
        SELECT
            `reg_id` AS GeoId,
            `ru_preposition` AS RuPreposition,
            `ru_prepositional` AS RuPrepositional,
        FROM hahn.`home/geotargeting/public/geobase/regions`
    );

    $images = (
        SELECT
            GeoId,
            Url AS RawImageUrl,
        FROM $region_images
    );

    $slugs = (
        SELECT
            geo_id AS GeoId,
            main_slug AS Slug,
        FROM $region_slugs
    );

    $res = (SELECT * FROM $geo_ids);
    $res = (SELECT * FROM $res AS res LEFT JOIN $region_popularity AS a USING (GeoId));
    $res = (SELECT * FROM $res AS res LEFT JOIN $regions_prepositional_case AS a USING (GeoId));
    $res = (SELECT * FROM $res AS res LEFT JOIN $slugs AS a USING (GeoId));
    $res = (SELECT * FROM $res AS res LEFT JOIN $images AS a USING (GeoId));

    SELECT
        GeoId,
        HasSeoPage,
        SeoPageFilterSlugs,
        Popularity ?? 0 AS Popularity,
        Unwrap(RuPreposition) AS RuPreposition,
        Unwrap(RuPrepositional) AS RuPrepositional,
        String::ReplaceAll(RawImageUrl ?? $default_image_url, "/orig", "/marketing-square") AS ImageUrl,
        Slug,
    FROM $res
END DEFINE;

DEFINE SUBQUERY $get_permalink_data($orders_from, $orders_to, $cluster_permalink_prices) AS
    $permalinks = (
        SELECT
            `cluster_permalink` AS Permalink,
            `geoid` AS GeoId,
            `rubric_permalink` AS RubricPermalink,
        FROM $permalink_to_hotel_info
        WHERE `publishing_status` == "publish"
    );

    $availability = (
        SELECT
            Permalink,
            AvailabilityProbability,
        FROM $cluster_permalink_availabilities
    );

    $prices = (
        SELECT
            `Permalink`,
            `SingleNightMedianMinPrice`
        FROM $cluster_permalink_prices
        WHERE SingleNightMedianMinPrice IS NOT NULL
    );

    $whitelists = (
        SELECT *
        FROM CONCAT(
            `//home/travel/prod/config/hotels_whitelist`,
            `//home/travel/prod/general/hotels_whitelist/exported`,
            `//home/travel/prod/hotels_administrator/whitelisted_hotels`
        )
    );

    $whitelisted_partners = ["PI_EXPEDIA", "PI_DOLPHIN", "PI_TRAVELLINE", "PI_BNOVO"];

    $has_mir_original_id = (
        SELECT
            b.`permalink` AS permalink,
            a.`Enabled` AS enabled,
            (NOT ListHas($whitelisted_partners, a.`PartnerId`) OR wl.`OriginalId` IS NOT NULL) AS whitelisted,
        FROM `//home/travel/prod/general/mir/latest/hotels` AS a
        JOIN `//home/travel/prod/general/altay_mappings/latest/partnerid_originalid_to_cluster_permalink` AS b ON (a.`PartnerIdInt` == b.`partnerid` AND a.`OriginalId` == b.`originalid`)
        LEFT JOIN $whitelists AS wl ON (a.`PartnerId` == wl.`PartnerId` AND a.`OriginalId` == wl.`OriginalId`)
    );

    $has_mir = (
        SELECT
            `permalink` AS Permalink,
            BOOL_OR(`enabled`) AS MirPromoAvailable,
        FROM $has_mir_original_id
        WHERE whitelisted
        GROUP BY `permalink`
    );

    $orders = (
        SELECT
            `label_original_hotel_id`,
            CAST(`label_partner_id` AS Int32) AS label_partner_id,
            `order_amount_rub`,
            `profit_amount_rub`,
        FROM $cpa_orders
        WHERE
            CAST(DateTime::FromSeconds(CAST(`created_at` AS Uint32)) AS Date) >= CAST($orders_from AS Date) AND
            CAST(DateTime::FromSeconds(CAST(`created_at` AS Uint32)) AS Date) <= CAST($orders_to AS Date) AND
            `status` == "confirmed" AND
            `label_original_hotel_id` != "" AND
            `label_partner_id` != ""
    );

    $permalink_aov = (
        SELECT
            b.permalink AS Permalink,
            AVG(`order_amount_rub`) AS AvgOrderAmountRub,
            AVG(`profit_amount_rub`) AS AvgProfitAmountRub,
            COUNT(*) AS OrderCnt,
        FROM $orders AS a
        JOIN $hotel_id_to_permalink AS b ON (a.label_original_hotel_id == b.originalid AND a.label_partner_id == b.partnerid)
        GROUP BY b.permalink
    );

    $hotel_features = (
        SELECT
            altay.permalink as Permalink,
            ListMap(altay.exported_company.Feature, ($feature) -> {
                RETURN ListMap($feature.ExportedValue, ($x) -> ($feature.Id || ":" || $x.TextValue))
            }) AS Features,
        FROM `//home/altay/db/export/current-state/exported/company` AS altay
        JOIN `//home/travel/prod/general/altay_mappings/latest/hotels_permalinks_published` AS hotels_published ON (altay.permalink == hotels_published.permalink)
    );

    $res = (SELECT * FROM $permalinks);
    $res = (SELECT * FROM $res AS res LEFT JOIN $prices AS a USING (Permalink));
    $res = (SELECT * FROM $res AS res LEFT JOIN $availability AS a USING (Permalink));
    $res = (SELECT * FROM $res AS res LEFT JOIN $has_mir AS a USING (Permalink));
    $res = (SELECT * FROM $res AS res LEFT JOIN $permalink_aov AS a USING (Permalink));
    $res = (SELECT * FROM $res AS res LEFT JOIN $hotel_features AS a USING (Permalink));
    SELECT * FROM $res;
END DEFINE;

DEFINE SUBQUERY $get_geo_ids_with_permalinks($region_queries_from, $region_queries_to, $orders_from, $orders_to, $cluster_permalink_prices) AS
    $geo_ids = (SELECT * FROM $get_geo_ids($region_queries_from, $region_queries_to));
    $permalink_data = (SELECT * FROM $get_permalink_data($orders_from, $orders_to, $cluster_permalink_prices));

    $permalink_with_regions_flatten = (
        SELECT *
        FROM (
            SELECT
                a.Permalink AS ClusterPermalink,
                a.GeoId AS GeoId,
                a.RubricPermalink AS RubricPermalink,
                a.AvailabilityProbability AS AvailabilityProbability,
                a.SingleNightMedianMinPrice AS SingleNightMedianMinPrice,
                a.MirPromoAvailable AS MirPromoAvailable,
                a.AvgOrderAmountRub AS AvgOrderAmountRub,
                a.AvgProfitAmountRub AS AvgProfitAmountRub,
                a.OrderCnt AS OrderCnt,
                a.Features AS Features,
                Yson::ConvertTo(b.`parents_ids`, List<Int32>) AS ParentId
            FROM $permalink_data AS a
            JOIN $geobase_table AS b
            ON (a.GeoId == b.reg_id)
        )
        FLATTEN LIST BY ParentId
    );

    $geo_ids_with_permalinks = (
        SELECT
            a.GeoId AS GeoId,
            a.HasSeoPage AS HasSeoPage,
            a.SeoPageFilterSlugs AS SeoPageFilterSlugs,
            a.Popularity AS Popularity,
            a.RuPreposition AS RuPreposition,
            a.RuPrepositional AS RuPrepositional,
            a.ImageUrl AS ImageUrl,
            a.Slug AS Slug,

            b.ClusterPermalink AS ClusterPermalink,
            b.RubricPermalink AS RubricPermalink,
            b.AvailabilityProbability AS AvailabilityProbability,
            b.SingleNightMedianMinPrice AS SingleNightMedianMinPrice,
            b.MirPromoAvailable AS MirPromoAvailable,
            b.AvgOrderAmountRub AS AvgOrderAmountRub,
            b.AvgProfitAmountRub AS AvgProfitAmountRub,
            b.OrderCnt AS OrderCnt,
            b.Features AS Features,
        FROM $geo_ids AS a
        LEFT JOIN $permalink_with_regions_flatten AS b
        ON (a.GeoId == b.ParentId)
    );

    SELECT *
    FROM $geo_ids_with_permalinks
END DEFINE;

EXPORT $get_geo_ids_with_permalinks, $get_permalink_data;
