# -*- coding: utf-8 -*-

from argparse import ArgumentParser
import logging
import sys
from travel.library.python.tools import replace_args_from_env

from travel.hotels.tools.permaroom_builder.builder.builder import Runner


def main():
    logging.basicConfig(level=logging.INFO, format="%(asctime)-15s | %(module)s | %(levelname)s | %(message)s",
                        stream=sys.stdout)
    logging.getLogger('yt.packages.urllib3.connectionpool').setLevel(logging.WARNING)

    parser = ArgumentParser()
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--yql-token', required=True)
    parser.add_argument('--yt-path', required=True)
    parser.add_argument('--moderation-results-path', required=True)
    parser.add_argument("--transfer-results", action='store_true')
    parser.add_argument("--transfer-destination", default='arnold')
    args = parser.parse_args(args=replace_args_from_env())
    Runner(args).run()


if __name__ == '__main__':
    main()
