# Спецификация хранения статических страниц в танкере

## Соглашения по именованию кейсетов

В танкере набор ключей группируется в так называемом кейсете.
У кейсета должно быть уникальное имя.
Чтобы обеспечить понятное и уникальное название каждого кейсета применяется следующая схема построения имени кейсета:

1. Для разделения уровней иерархии применяется символ `.`
2. Иерархия повторяет структуру папок в аркадии от корня путешествий `${ARCADIA_ROOT}/travel`
3. Внутри приложения может присутствовать дополнительная иерархия для более удобного разделения

**Пример:**
Кейсет статических страниц отелей в API путешествий будет конструироваться так:

1. Папка API в аркадии: `travel-api`
2. Внутреннее разделение на подсервисы внутри API, нам нужны отели: `travel-api.hotels`
3. Компонент подсервиса для отображения статических страниц: `travel-api.hotels.city-page` или `travel-api.hotels.state-page`
4. Окружение, для которого предназначен кейсет: `travel-api.hotels.city-page.testing`

Настройки хранятся в отдельных кейсетах `travel-api.hotels.config.testing` и `travel-api.hotels.config.prod`

## Кейсет для статических страниц отелей travel-api

Все данные статических страниц регионов хранятся в кейсете с id `travel-api.hotels.city-page`.


## Структура страницы региона

### Категории региона

Для удобства генерации статических страниц, каждый регион может быть отнесен к какой-то одной категории.
Принадлежность региона к категории определяется аналитиками и будет меняться крайне редко.

Примеры категорий:
- Курорт (`resort`), сюда попадают курортные города, например, Сочи
- Крупный город (`big-city`), сюда попадают крупные города с большим потоком командировок, например Москва, Екатеринбург

### Приоритет ключей страницы региона

Структура статической страницы описывается в ключах с определенным именем.
Приоритет ключей описания структуры страницы для отображения:

1. `region.page.region-{geo-id}`, где `geo-id` - идентификатор региона в геобазе (??? geo_id vs region_slug ???).
2. `region.page.region-{slug}`, где `slug` - постоянное имя региона
3. `region.page.category-{category-id}`, где `category-id` - текстовый код категории, например `resort`.
4. `region.page.default`, структура страницы по умолчанию.

Для построения таблицы используется описание структуры с наивысшим приоритетом.
Если не найдено описание структуры страницы для конкретного региона и категории региона, то используется структура страницы по умолчанию.

### Формат описания структуры страницы региона

Структуры страницы региона описывается на языке yaml в следующем формате:

```
seo: (строка) id блока шаблона seo данных страницы
content: (массив строк): список id блоков шаблонов  контента страницы
```

Пример описания структуры страницы:

```yaml
seo: region.block.seo.default
content:
  - region.block.heading.default
  - region.block.hotel_list.default
  - region.block.cross_links.default
```

## Блоки

Общий формат ключей блоков:
`region.block.ТипБлока.НазваниеБлока`

### SEO блок

Тип блока: `seo`
Все seo блоки хранятся в ключах с префиксом `region.block.seo`.
Пример: `region.block.seo.moscow`

**Формат**:
```
title: (строка) title страницы
description: (строка) description страницы
openGraph:
  title: (строка) OpenGraph Title страницы, для тэгов og:title и twitter:title
  description: (строка) OpenGraph Description страницы, для тэгов og:description и twitter:description
```

**Пример**:

```yaml
title: Отели {{city|locative}} — цены, рейтинг, отзывы на Яндекс.Путешествиях
description: >
  Сравнивайте цены на отели, гостиницы, хостелы и другие варианты размещения {{city|locative}}. Поиск недорогих отелей по местоположению, услугам, реальным отзывам посетителей. Забронируйте идеальный вариант размещения для вашей поездки по лучшей цене на Яндекс.Путешествиях.
openGraph:
  title: Отели {{city|locative}} — цены, рейтинг, отзывы на Яндекс.Путешествиях
  description: >
    Сравнивайте цены на отели, гостиницы, хостелы и другие варианты размещения {{city|locative}}. Поиск недорогих отелей по местоположению, услугам, реальным отзывам посетителей. Забронируйте идеальный вариант размещения для вашей поездки по лучшей цене на Яндекс.Путешествиях.
```

### Блок формы поиска

Тип блока: `heading`
Все блоки формы поиска хранятся в ключах с префиксом `region.block.heading`.
Пример: `region.block.heading.moscow`.

**Формат**:
```
title: (строка) Заголовок формы поиска
isCalendarOpen: (boolean) Признак открытого селекта календаря
```

**Пример**:
```yaml
title: Поиск отелей в {{regionName.locative}}
```

### Блок списка отелей

Тип блока: `hotel_list`
Блоки списков отелей хранятся в ключах с префиксом `region.block.hotel_list`.
Пример: `region.block.hotel_list.moscow_top_hotels`.

**Формат**:
```typescript
title: (строка) Заголовок блока
geoSearchRequestData:
  limit: (int) Количество отелей в ответе, по умолчанию 4
  geoId: (int) Идентификатор региона. Должен присутствовать либо geoId, либо bboxString
  bboxString: (строка) Строковое представление bounding box. Должен присутствовать либо geoId, либо bboxString
  filters: (массив строк) атомы фильтров для запроса в геопоиск
  sortType: Порядок сортировки: "relevant-first" (по умолчанию), "cheap-first" или "expensive-first"
hotelExtraItems:
  nearestStations: (true/false) Показывать для отеля ближайшие станции. По умолчанию – false
  cityName: (true/false) Показывать для отеля название города. По умолчанию – false
```

**Пример**:

```yaml
title: Отели c бассеином и видом на море в {{city|locative}}
geoSearchRequestData:
  limit: 5
  geoId: {{geoId}}
  sortType: popularity
  filters:
    - pool
  hotelExtraItems:
    cityName: true
```

### Блок частых вопросов

Тип блока: `faq`

Блоки частых вопросов хранятся в ключах с префиксом `region.block.faq.`. Пример: `region.block.faq.default`.

Вопросы и ответы из блока частых вопросов попадают в SchemaOrg данные для SEO.

**Формат**

Блок частых вопросов задается в виде шаблона HTML. Подробнее о шаблонизации написано [тут](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/tools/region_pages_builder/docs/templates.md).

Корневым тэгом должен быть `<div>`.

Поддерживается следующая структура блока:
```
<div>
  <h2>Заголовок блока</h2>
  <div class="question">
    <h3>Вопрос</h3>
    <p>Ответ</p>
  </div>
</div>
```

Блоков `<div class"question">` может быть несколько.

Внутри тэга `<p>` поддерживаются следующие тэги:

* `<i>` *Наклонный* `</i>` текст
* `<b>` **Жирный** `</b>` текст
* `<a href="url">` Ссылка на внешний URL `</a>`

**Пример**

```
<div>
  <h2>Часто задаваемые вопросы об отелях {{city|locative}}</h2>
  {% if top_hotels_1 %}
  <div class="question">
    <h3>В каких отелях лучше всего остановиться {{city|locative}}?</h3>
    <p>{{top_hotels_1.link}} получает отличные отзывы на Яндекс.Путешествиях.{% if top_hotels_1.stars and top_hotels_1.top_features %} Этот {{top_hotels_1.stars}}-звёздочный отель предоставляет гостям {{rjoin(top_hotels_1.top_features, 'accusative', limit=3)}}.{% endif %}{% if top_hotels_2 and top_hotels_3 %} Хорошую оценку также получили {{top_hotels_2.link}} и {{ top_hotels_3.link}}, это лучшие варианты для путешествия {{city|locative}}.{% endif %}</p>
  </div>
  {% endif %}
</div>

```

### Блок текстового контента

Тип блока: `text`

Блоки частых вопросов хранятся в ключах с префиксом `region.block.text.`. Пример: `region.block.text.default`.

**Формат**

Блок текстового контента задается в виде шаблона HTML. Подробнее о шаблонизации написано [тут](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/tools/region_pages_builder/docs/templates.md).

Корневым тэгом должен быть `<div class="section">`.

Поддерживается следующая структура блока:

```
<div class="section">
  <h2>Заголовок блока</h2>
  <p>Текст</p>
  <div class="spoiler">
    <h3>Заголовок спойлера</h3>
    <p>Текст, скрытый под спойлер</p>
  </div>
  <div class="subsection">
    <h3>Подзаголовок</h3>
    <p>Текст</p>
  </div>
</div>
```

Внутри тэга `<p>` поддерживаются следующие тэги:

* `<i>` *Наклонный* `</i>` текст
* `<b>` **Жирный** `</b>` текст
* `<a href="url">` Ссылка на внешний URL `</a>`

**Пример**

```
<div class="section">
  <p>
    {% if city.min_price %}
      Найдите идеальный вариант размещения от {{city.min_price}} рублей за ночь,
      выбрав среди отелей, гостиниц и других объектов  {{city|locative}}.
    {% endif %}
  </p>
</div>
```

### Блок кросс-ссылок

Тип блока: `cross_links`
Блоки списков отелей хранятся в ключах с префиксом `region.block.cross_links`.
Пример: `region.block.cross_links.default`.

**Формат**:
```typescript
title: (строка) Заголовок блока
```

**Пример**:

```yaml
title: Популярные направления
```

Общая конфигурация генерации кросс-ссылок задается в специальном ключе танкера `region.cross_links_config`

**Формат** конфигурации:

```
regions:  (особые настройки для регионов)
  <slug>:
    incomingLinksCount: (число) число входящих ссылок на регион
    fixedLinks: (список фиксированных ссылок на регионы)
      - <slug>
```

Вместо `<slug>` ожидаются slug региона.

**Пример**
```
regions:
  moscow:
    incomingLinksCount: 1000
    fixedLinks:
      - yekaterinburg
      - perm
      - vladivostok
```

### Блок групп ссылок на регионы с фильтрами

Для добавления блока в шаблон используется ключ `region.block.filter_set`
Настройка блока задаётся в [конфигурации](#группы-фильтров). Описание блока в отдельном ключе не требуется

**Пример**
```
regions:
  moscow:
    incomingLinksCount: 1000
    fixedLinks:
      - yekaterinburg
      - perm
      - vladivostok
```


### Названия регионов

Можно переопределить в отдельном кейсете `travel-api.dictionaries.{prod|testing}` ключ `region-name`. Для этого нужно
указать все склонения названия региона

**Формат**:

```
<slug>:
  moscow-oblast:
    nominative: <text> - имя города в именительном падеже
    genitive: <text> - имя города в родительном падеже
    dative: <text> - имя города в дательном падеже
    accusative: <text> - имя города в винительном падеже
    instrumental: <text> - имя города в творительном падеже
    prepositional: <text> - имя города в предложном падеже
    preposition: <text> - предлог (в, на) для предложного падежа
```

Вместо `<slug>` ожидается главный slug региона.

**Пример**
```yaml
moscow-oblast:
  nominative: Московская область
  genitive: Московской области
  dative: Московской области
  accusative: Московскую область
  instrumental: Московской областью
  prepositional: Московской области
  preposition: в
```

## Настройки

Настройки хранятся в отдельных кейсетах `travel-api.hotels.config.testing` и `travel-api.hotels.config.prod`

### Регионы с фильтрами

Блоки списков отелей хранятся в ключах с префиксом `filter.`.
Пример: `filter.5star`.

**Формат**:
```typescript
name: string;  // название фильтра, используется для хлебных крошек
filterSlug: string;  // slug фильтра
category: string;  // категория (для выбора нужного шаблона)
yqlCondition: string;  // параметры фильтра для YQL подготовки данных
regions: string[];  // регионы, для которых нужно формировать страницы с фильтрами
geoSearchFilters: string[];  // атомы фильтров для запроса в геопоиск
```

**Пример**:

```yaml
name: 5*
filterSlug: filter-five-star
category: featured-hotels
yqlCondition: stars == 5
geoSearchFilters:
  - star:five
regions:
  - yekaterinburg
```

`geoSearchFilters` также есть в блоке со списком отелей. Итоговый `geoSearchFilters` формируется объединением списков

!!! ВАЖНО
Изменение слага фильтра конфликтует с сохранением исчезнувших регионов и приводит к ошибке рендеринга. Рекомендуется определиться со слагами в тестинге, чтобы не было необходимости изменять их в проде

### Группы фильтров
Блоки списков отелей хранятся в ключе `filter-set`.

**Пример**:

```yaml
title: Подборки отелей по критериям  # заголовок блока
subsets:
-
  title: По звёздам  # заголовок группы
  filters:
  -
    slug: 5-star  # slug фильтра
    name: 5 звёзд  # название фильтра (если не задано, будет использоваться название из настроек фильтра)
  -
    slug: 4-star
    name: 4 звезды
```
