import logging
from typing import Optional


class IHaveExceptionKey:
    def get_key(self):
        raise NotImplementedError()


class RenderExceptionContainer:
    def __init__(self):
        self.exceptions = {}

    def add_exception(self, exception: Exception, exception_key: Optional[str] = None, exception_metadata: Optional[str] = None):
        if exception_key is None:
            if isinstance(exception, IHaveExceptionKey):
                exception_key = exception.get_key()
            else:
                exception_key = exception.__class__.__name__

        self.exceptions.setdefault(exception_key, []).append((exception, exception_metadata))

    def check_and_raise(self, exception_limit=10):
        if len(self.exceptions) != 0:
            for (i, (key, exception_list)) in enumerate(self.exceptions.items()):
                if i == exception_limit:
                    break

                exception_example = exception_list[0][0]
                metadata_list = list(map(lambda x: str(x[1]), filter(lambda x: x is not None, exception_list)))

                if len(metadata_list) <= 3:
                    metadata_message = ", ".join(metadata_list)
                else:
                    metadata_message = ", ".join(metadata_list[:3]) + f" and {len(metadata_list) - 3} more"

                logging.exception(f"{len(exception_list)} exceptions with key '{key}' happened for {metadata_message}. Example:", exc_info=exception_example)

            total_exception_count = sum(map(lambda exc_list: len(exc_list), self.exceptions.values()))

            raise Exception(f"Total {total_exception_count} exceptions happened on run so exception will be thrown")
