from yql.api.v1.client import YqlClient
from yt.wrapper import YtClient, ypath_join


class Processor:

    def __init__(
        self,
        yt_client: YtClient,
        yql_client: YqlClient,
        query_args: dict[str, str],
    ):
        self.yt_client = yt_client
        self.yql_client = yql_client
        self.result_dir = query_args['$result_dir']
        self.parsed_permalinks_path = query_args['$parsed_permalinks_path']

    def pre_process(self):
        result_path = ypath_join(self.result_dir, 'parsed_permalinks')
        self.yt_client.copy(self.parsed_permalinks_path, result_path)

    def post_process(self):
        pass
