# -*- coding: utf-8 -*-

from argparse import ArgumentParser
import logging
import sys
import uuid
import subprocess

from yt.wrapper import YtClient

from library.python.spyt.executable import spyt_main

from travel.library.python.tools import replace_args_from_env

LOG = logging.getLogger(__name__)


def run_spyt_main():
    from spyt import spark_session

    from travel.hotels.tools.spyt_runner.altay_mappings_builder import AltayMappingBuilder

    @spyt_main
    def inner_main():
        dir_path = '//home/travel/mpivko/tmp/spark-experiments/altay-mappings'

        with spark_session() as spark:
            builder = AltayMappingBuilder(spark, f'{dir_path}/1')
            LOG.info('Starting AltayMappingBuilder')
            builder.build()
            LOG.info('Done')

    inner_main()


class Runner:
    def __init__(self, args):
        self.yt_client = YtClient(proxy=args.yt_proxy, token=args.yt_token)
        self.args = args

    def run(self):
        guid = uuid.uuid4()
        path = f'//home/travel/mpivko/tmp/spyt_runners/{guid}'
        LOG.info(f'Uploading to path: {path}')
        self.yt_client.smart_upload_file(sys.executable, path, placement_strategy='replace')
        try:
            cmd = f'./spark-submit-yt --deploy-mode cluster --proxy {self.args.yt_proxy} --discovery-path //home/travel/mpivko/tmp/spark --conf spark.executor.memory=16G yt:/{path}'
            code = subprocess.call(cmd, shell=True, env={'YT_TOKEN': self.args.yt_token}, cwd='/usr/local/bin/')
            LOG.info(f'spark-submit-yt return code: {code}')
        finally:
            self.yt_client.remove(path, True)


def main():
    logging.basicConfig(level=logging.INFO, format="%(asctime)-15s | %(module)s | %(levelname)s | %(message)s",
                        stream=sys.stdout)
    logging.getLogger('yt.packages.urllib3.connectionpool').setLevel(logging.WARNING)

    parser = ArgumentParser()
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token')
    parser.add_argument('--runner-mode', action='store_true')
    args = parser.parse_args(args=replace_args_from_env())
    if args.runner_mode:
        Runner(args).run()
    else:
        run_spyt_main()
