package ru.yandex.travel.hotels.tugc

import kotlin.Array
import kotlin.String

import org.slf4j.LoggerFactory
import org.springframework.boot.SpringApplication
import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.context.annotation.Import
import ru.yandex.travel.hotels.cluster_permalinks.ClusterPermalinkService
import ru.yandex.travel.hotels.cluster_permalinks.ClusterPermalinkServiceHealthIndicator
import ru.yandex.travel.infrastructure.ConfigProcessorApplicationListener
import ru.yandex.travel.natives.Natives

@SpringBootApplication
@Import(value = [ClusterPermalinkService::class, ClusterPermalinkServiceHealthIndicator::class])
open class TugcApplication {


    companion object {
        private val log = LoggerFactory.getLogger(TugcApplication::class.java)

        @JvmStatic
        fun main(args: Array<String>) {
            if (System.getenv("LOCK_MEMORY").toBoolean()) {
                log.info("Locking virtual memory pages to RAM")
                Natives.tryMlockall()
            }

            val app = SpringApplication(TugcApplication::class.java)

            app.addListeners(ConfigProcessorApplicationListener())
            app.run(*args)
        }
    }

}
