package ru.yandex.travel.hotels.tugc.entities

import org.jooq.Record
import java.time.LocalDateTime

import ru.yandex.travel.hotels.tugc.tables.records.FavoriteRecord

data class Favorite(
    val puid: Long?,
    val yuid: String?,
    val permalink: Long,
    val geoId: Int,
    val createdAt: LocalDateTime = LocalDateTime.now()
)

fun FavoriteRecord.toEntity() = Favorite(
    if (userId.startsWith("puid")) userId.slice(IntRange(5, userId.length - 1)).toLong() else null,
    if (userId.startsWith("yuid")) userId.slice(IntRange(5, userId.length - 1)) else null,
    permalink,
    geoId,
    createdAt
)

fun Record.toFavoriteEntity() = (this as FavoriteRecord).toEntity()

fun Favorite.record() = FavoriteRecord(
    puid?.let { "puid_$puid" } ?: "yuid_$yuid",
    permalink,
    geoId,
    createdAt
)
