package ru.yandex.travel.hotels.tugc.grpc

import ru.yandex.travel.hotels.proto.tugc_service.*
import ru.yandex.travel.hotels.tugc.entities.Favorite

object FavoriteRspBuilder {
    fun buildGetFavoriteHotelsRsp(favorites: List<Favorite>): TGetFavoriteHotelsRsp = TGetFavoriteHotelsRsp.newBuilder()
        .addAllPermalinks(favorites.map { it.permalink })
        .build()

    fun buildGetHotelFavoriteInfosRsp(favorites: List<Favorite>, requestedPermalinks: List<Long>, requestedPermalinksByCluster: List<List<Long>>): TGetHotelFavoriteInfosRsp {
        val favoritePermalinks = favorites.map { it.permalink }.toHashSet()
        val rspBuilder = TGetHotelFavoriteInfosRsp.newBuilder()

        requestedPermalinks.mapIndexed { index, permalink ->
            val isFavorite = requestedPermalinksByCluster[index].any { favoritePermalinks.contains(it) }
            val permalinkInfo = TGetHotelFavoriteInfosRsp.TPermalinkInfo.newBuilder()
                .setPermalink(permalink)
                .setIsFavorite(isFavorite)
                .build()

            rspBuilder.addPermalinkInfos(permalinkInfo)
        }

        return rspBuilder.build()
    }

    fun buildAddFavoriteHotelRsp(): TAddFavoriteHotelRsp = TAddFavoriteHotelRsp.newBuilder().build()

    fun buildRemoveFavoriteHotelsRsp(): TRemoveFavoriteHotelsRsp = TRemoveFavoriteHotelsRsp.newBuilder().build()

    fun buildGetGeoIds(geoIds: Map<Int, Int>): TGetGeoIdsRsp = TGetGeoIdsRsp.newBuilder()
        .addAllGeoIds(geoIds.keys)
        .addAllGeoIdInfos(geoIds.map { x -> TGetGeoIdsRsp.TGeoIdInfo.newBuilder().setGeoId(x.key).setPermalinkCount(x.value).build() })
        .build()
}
