RECURSE(
    src/test
)

JAVA_PROGRAM(tugc)

JDK_VERSION(11)
WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/generated **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

PEERDIR(
    travel/library/java/spring-boot-skeleton
    travel/hotels/lib/java/cluster_permalinks
    travel/hotels/proto/tugc_service
    travel/library/java/natives

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/jooq/jooq
    contrib/java/org/flywaydb/flyway-core

    contrib/java/org/jetbrains/kotlin/kotlin-reflect
    contrib/java/javax/persistence/javax.persistence-api/2.2
    contrib/java/org/springframework/boot/spring-boot-starter-validation
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/tugc.py
    CUSTOM_PROPERTY appName tugc
    CUSTOM_PROPERTY mainClass ru.yandex.travel.hotels.tugc.TugcApplication
)

LINT(base)

END()
