package ru.yandex.travel.hotels.tugc.db.codegen

import org.apache.commons.cli.DefaultParser
import org.apache.commons.cli.Option
import org.apache.commons.cli.Options
import org.jooq.codegen.GenerationTool

class JooqGenerationTool {

    companion object {
        @JvmStatic
        fun main(args: Array<String>) {
            val configuration = GenerationTool.load(JooqGenerationTool::class.java.getResourceAsStream("/jooq-config.xml"))
            val optionDBUrl = Option.builder("U")
                .desc("DB Url")
                .longOpt("url")
                .hasArg()
                .build()
            val optionDBUser = Option.builder("u")
                .desc("DB User")
                .longOpt("user")
                .hasArg()
                .build()
            val optionDBPassword = Option.builder("p")
                .desc("DB Password")
                .longOpt("pass")
                .hasArg()
                .build()
            val options = Options()
                .addOption(optionDBUrl)
                .addOption(optionDBUser)
                .addOption(optionDBPassword)
            val commandLine = DefaultParser().parse(options, args)

            if (commandLine.hasOption(optionDBUrl.opt)) {
                configuration.jdbc.url = commandLine.getOptionValue(optionDBUrl.opt)
            }

            if (commandLine.hasOption(optionDBUser.opt)) {
                configuration.jdbc.user = commandLine.getOptionValue(optionDBUser.opt)
            }

            if (commandLine.hasOption(optionDBPassword.opt)) {
                configuration.jdbc.password = commandLine.getOptionValue(optionDBPassword.opt)
            }

            GenerationTool.generate(configuration)
        }
    }

}
