package main

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/travel/komod/trips/internal/components/api"
	"a.yandex-team.ru/travel/komod/trips/internal/middlewares"
)

var (
	externalAPIPattern = `^/external-api`
)

func getMiddlewares(logger log.Logger, tvmClient tvm.Client) []middlewares.Middleware {
	return []middlewares.Middleware{
		middlewares.Tvm(middlewares.TvmArgs{
			AllowClientIDs: []uint32{api.Cfg.Tvm.StatefulSearchID, api.Cfg.Tvm.SelfAppID},
			Logger:         logger,
			TvmClient:      tvmClient,
		}).
			Include(externalAPIPattern).
			MustBuild(),
		middlewares.RateLimiter(middlewares.RateLimiterArgs{
			Logger: logger,
			Limit:  api.Cfg.RateLimits.External,
		}).
			Include(externalAPIPattern).
			MustBuild(),
	}
}
