package main

import (
	"context"

	"google.golang.org/grpc"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/api/trips/v1"
)

type APIClient struct {
	client trips.TripsServiceV1Client
}

func NewAPIClient(conn *grpc.ClientConn) *APIClient {
	return &APIClient{client: trips.NewTripsServiceV1Client(conn)}
}

func (c *APIClient) GetTrips(ctx context.Context) *trips.GetTripsRsp {
	rsp, err := c.client.GetTrips(
		ctx,
		&trips.GetTripsReq{
			PassportId: Cfg.PassportID,
			PastLimit:  20,
		},
	)
	if err != nil {
		logger.Fatal(
			"fail to call api",
			log.Error(err),
		)
	}
	return rsp
}

func (c *APIClient) GetTripAsyncBlocks(ctx context.Context, tripID string, blockTypes ...trips.BlockType) *trips.GetTripAsyncBlocksRsp {
	rsp, err := c.client.GetTripAsyncBlocks(
		ctx,
		&trips.GetTripAsyncBlocksReq{
			TripId:     tripID,
			BlockTypes: blockTypes,
		},
	)
	if err != nil {
		logger.Fatal(
			"fail to call api",
			log.Error(err),
		)
	}
	return rsp
}

func (c *APIClient) GetTrip(ctx context.Context, tripID string) *trips.GetTripRsp {
	rsp, err := c.client.GetTrip(
		ctx,
		&trips.GetTripReq{
			PassportId: Cfg.PassportID,
			TripId:     tripID,
		},
	)
	if err != nil {
		logger.Fatal(
			"fail to call api",
			log.Error(err),
		)
	}
	return rsp
}

func (c *APIClient) GetTripIDByOrderID(ctx context.Context, orderID string) *trips.GetTripIdByOrderIdRsp {
	rsp, err := c.client.GetTripIdByOrderId(
		ctx,
		&trips.GetTripIdByOrderIdReq{
			OrderId: orderID,
		},
	)
	if err != nil {
		logger.Fatal(
			"fail to call api",
			log.Error(err),
		)
	}
	return rsp
}
