package main

import (
	"context"
	stdlog "log"

	"a.yandex-team.ru/travel/library/go/configuration"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	Logging logging.Config

	LocalAddr  string `yaml:"local_addr"`
	YPlannerID string `yaml:"y_planner_id"`

	TvmID     int    `yaml:"tvm_id"`
	TvmSecret string `yaml:"tvm_secret"`

	BlackboxHost       string `yaml:"blackbox_host"`
	BlackboxOAuthToken string `yaml:"blackbox_oauth_token"`
	PassportID         string `yaml:"passport_id"`
	YandexUID          string `yaml:"yandex_uid"`
}

var Cfg = Config{
	Logging: logging.DefaultConfig,
}

func setupConfig() {
	ctx, ctxCancel := context.WithCancel(context.Background())
	defer ctxCancel()
	config := configuration.NewDefaultConfitaLoader()
	err := config.Load(ctx, &Cfg)

	if err != nil {
		stdlog.Fatalf("can not load configuration: %s", err)
	}
}
