package main

import (
	"context"
	"encoding/json"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
)

func main() {
	setupConfig()
	setupLogging()
	conn := getConnection()
	defer conn.Close()

	ctx := getContextWithCredentials(
		context.Background(),
		Cfg.YandexUID,
		Cfg.PassportID,
		getUserTicket(
			Cfg.TvmID,
			Cfg.TvmSecret,
			Cfg.BlackboxOAuthToken,
		),
		getServiceTicket(
			Cfg.TvmID,
			Cfg.TvmID,
			Cfg.TvmSecret,
		),
	)

	client := NewAPIClient(conn)
	PrettyPrintResult(client.GetTrips(ctx))
}

func PrettyPrintResult(v interface{}) {
	content, err := json.MarshalIndent(v, "", "  ")
	if err != nil {
		logger.Fatal("could not convert value to json", log.Error(err))
	}

	fmt.Printf("Result is: %s", content)
}
