package main

import (
	"context"

	"google.golang.org/grpc"
	"google.golang.org/protobuf/types/known/timestamppb"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/api/processor/v1"
)

type ProcessorClient struct {
	client processor.ProcessorServiceV1Client
}

func NewProcessorClient(conn *grpc.ClientConn) *ProcessorClient {
	return &ProcessorClient{client: processor.NewProcessorServiceV1Client(conn)}
}

func (c ProcessorClient) ProcessOrder(ctx context.Context, orderID string) {
	const defaultRetriesCount = 3
	_, err := c.client.ProcessTripEntity(
		ctx,
		&processor.ProcessTripEntityReq{
			CollectedAt: timestamppb.Now(),
			Entity: &processor.ProcessTripEntityReq_Order{
				Order: &processor.OrderEntity{Id: orderID},
			},
			RetriesLeft: defaultRetriesCount,
		},
	)
	if err != nil {
		logger.Fatal(
			"fail to call processor",
			log.Error(err),
			log.String("order_id", orderID),
		)
	}
}
