package main

import (
	"fmt"

	"gorm.io/gorm"
)

func declareCursor(db *gorm.DB) error {
	return db.Exec(`
				BEGIN;
				DECLARE cur CURSOR WITH HOLD FOR
					select 
						au.order_id
					from authorized_users as au
					join order_aggregate_states as st on au.order_id = st.id
					join orders as o on au.order_id = o.id
					where 
						au.passport_id != '' and 
						(au.passport_id is not null) and 
						au.role = 'OWNER' and 
						st.order_display_state in (4, 5) and 
						o.display_type in (1, 2, 3);
				COMMIT;
			`).Error
}

func closeCursor(db *gorm.DB) error {
	return db.Exec("CLOSE cur;").Error
}

func fetchPage(pageSize uint, db *gorm.DB) ([]string, error) {
	page := make([]string, 0, pageSize)
	err := db.Raw(fmt.Sprintf("FETCH %d FROM cur;", pageSize)).Scan(&page).Error
	return page, err
}

func getTotalOrdersCount(db *gorm.DB) (int, error) {
	totalOrders := 0
	err := db.Raw(`
					select 
						count(1)
					from authorized_users as au
					join order_aggregate_states as st on au.order_id = st.id
					join orders as o on au.order_id = o.id
					where 
						au.passport_id != '' and 
						(au.passport_id is not null) and 
						au.role = 'OWNER' and 
						st.order_display_state in (4, 5) and 
						o.display_type in (1, 2, 3);
			`).Scan(&totalOrders).Error
	return totalOrders, err
}
