package profiling

import (
	"net/http"
	"net/http/pprof"

	"github.com/go-chi/chi/v5"
)

type Config struct {
	Addr            string
	HeapRoute       string
	GoroutinesRoute string
}

var DefaultConfig = Config{
	Addr:            "[::]:80",
	HeapRoute:       "/profiling/heap",
	GoroutinesRoute: "/profiling/goroutines",
}

type Service struct {
	config Config
}

func NewService(config Config) *Service {
	return &Service{config: config}
}

func (s *Service) BackroundRun() {
	router := chi.NewRouter()
	router.Get(s.config.HeapRoute, pprof.Handler("heap").ServeHTTP)
	router.Get(s.config.GoroutinesRoute, pprof.Handler("goroutine").ServeHTTP)
	go func() {
		_ = http.ListenAndServe(s.config.Addr, router)
	}()
}
