package tvm

import (
	"time"
)

type Config struct {
	Enabled       bool          `config:"TVM_ENABLED" yaml:"enabled"`
	Whitelist     []uint32      `config:"TVM_WHITELIST" yaml:"whitelist"`
	SelfAppID     uint32        `config:"TVM_SELFAPP_ID,required" yaml:"self_app_id"`
	CacheTTL      time.Duration `config:"TVM_CACHE_TTL" yaml:"cache-ttl"`
	CacheMaxItems int           `config:"TVM_CACHE_MAX_ITEMS" yaml:"cache-max-items"`

	StatefulSearchID uint32 `yaml:"stateful_search_id"`
}

var DefaultConfig = Config{
	Enabled:       false,
	Whitelist:     []uint32{2032083},
	SelfAppID:     2032083,
	CacheTTL:      3 * time.Minute,
	CacheMaxItems: 128,

	StatefulSearchID: 2034711,
}
