package comparators

import (
	"sort"

	"a.yandex-team.ru/travel/komod/trips/internal/span"
	"a.yandex-team.ru/travel/komod/trips/internal/trips/models"
)

type OrderInfoComparator struct {
	spanComparator span.SpanComparator
}

func (c OrderInfoComparator) Compare(lhs, rhs models.OrderInfo) bool {
	return lhs.ID == rhs.ID &&
		lhs.CancelledByUser() == rhs.CancelledByUser() &&
		c.spanComparator.CompareSlices(lhs.Spans, rhs.Spans)
}

type orderInfosByID []models.OrderInfo

func (b orderInfosByID) Len() int {
	return len(b)
}

func (b orderInfosByID) Less(i, j int) bool {
	return b[i].ID < b[j].ID
}

func (b orderInfosByID) Swap(i, j int) {
	b[i], b[j] = b[j], b[i]
}

func (c OrderInfoComparator) CompareSlices(lhs, rhs []models.OrderInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	sort.Sort(orderInfosByID(lhs))
	sort.Sort(orderInfosByID(rhs))

	for i, leftItem := range lhs {
		if c.Compare(leftItem, rhs[i]) {
			return false
		}
	}
	return true
}
