package comparators

import (
	"sort"

	"a.yandex-team.ru/travel/komod/trips/internal/orders"
	"a.yandex-team.ru/travel/komod/trips/internal/trips/models"
)

type TripComparator struct {
	orderInfoComparator OrderInfoComparator
}

func (c TripComparator) Compare(lhs, rhs *models.Trip) bool {
	return lhs.ID == rhs.ID &&
		lhs.PassportID == rhs.PassportID &&
		c.compareOrderInfos(lhs.OrderInfos, rhs.OrderInfos)
}

type tripsByID models.Trips

func (b tripsByID) Len() int {
	return len(b)
}

func (b tripsByID) Less(i, j int) bool {
	return b[i].ID < b[j].ID
}

func (b tripsByID) Swap(i, j int) {
	b[i], b[j] = b[j], b[i]
}

func (c TripComparator) CompareSlices(lhs, rhs models.Trips) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	sort.Sort(tripsByID(lhs))
	sort.Sort(tripsByID(rhs))

	for i, leftTrip := range lhs {
		if !c.Compare(leftTrip, rhs[i]) {
			return false
		}
	}
	return true
}

func (c TripComparator) compareOrderInfos(lhs, rhs map[orders.ID]models.OrderInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	for id, leftInfo := range lhs {
		rightInfo, found := rhs[id]
		if !found || !c.orderInfoComparator.Compare(leftInfo, rightInfo) {
			return false
		}
	}
	return true
}
