package api

import (
	"a.yandex-team.ru/travel/avia/library/go/probes"
	"a.yandex-team.ru/travel/komod/trips/internal/common/dynamicresources"
	"a.yandex-team.ru/travel/komod/trips/internal/common/healthcheck"
	"a.yandex-team.ru/travel/komod/trips/internal/common/tvm"
	"a.yandex-team.ru/travel/komod/trips/internal/components/api/trips"
	apiweather "a.yandex-team.ru/travel/komod/trips/internal/components/api/trips/weather"
	"a.yandex-team.ru/travel/komod/trips/internal/db"
	"a.yandex-team.ru/travel/komod/trips/internal/notifier"
	"a.yandex-team.ru/travel/komod/trips/internal/orders/clients"
	"a.yandex-team.ru/travel/komod/trips/internal/references"
	activityclients "a.yandex-team.ru/travel/komod/trips/internal/services/activities/clients"
	"a.yandex-team.ru/travel/komod/trips/internal/services/cityimages"
	"a.yandex-team.ru/travel/komod/trips/internal/services/contentadmin"
	"a.yandex-team.ru/travel/komod/trips/internal/services/testing"
	"a.yandex-team.ru/travel/komod/trips/internal/services/unprocessedorders"
	"a.yandex-team.ru/travel/komod/trips/internal/services/weather"
	"a.yandex-team.ru/travel/komod/trips/internal/sharedflights"
	"a.yandex-team.ru/travel/library/go/geobase"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	EnvType           string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Dicts             references.Config
	DynamicResources  dynamicresources.Config `yaml:"dynamic_resources"`
	Logging           logging.Config
	Grpc              grpcserver.GrpcConfig
	HTTP              httpserver.HTTPConfig
	Tvm               tvm.Config
	Geobase           geobase.Config
	OrdersClient      clients.Config `yaml:"orders_client"`
	HealthCheck       healthcheck.Config
	Probes            probes.HTTPConfig
	UnprocessedOrders unprocessedorders.Config `yaml:"unprocessed_orders"`
	Testing           testing.Config
	Database          db.Config
	RaspMediaURL      string              `yaml:"rasp_media_url"`
	ContentAdmin      contentadmin.Config `yaml:"content_admin"`
	CityImages        cityimages.Config
	AfishaClient      activityclients.AfishaConfig    `yaml:"afisha_client"`
	IziTravelClient   activityclients.IziTravelConfig `yaml:"izi_travel_client"`
	Provider          trips.ProviderConfig            `yaml:"provider"`
	Notifier          notifier.Config                 `yaml:"notifier"`
	SharedFlights     sharedflights.Config            `yaml:"shared_flights"`
	WeatherProvider   apiweather.Config               `yaml:"weather_provider"`
	WeatherClient     weather.HTTPClientConfig        `yaml:"weather_client"`
	RateLimits        RateLimits                      `yaml:"rate_limits"`
}

func (c *Config) IsDevelopment() bool {
	return c.EnvType == "development"
}

type RateLimits struct {
	External int
}

var DefaultRateLimits = RateLimits{
	External: 5,
}

var Cfg = Config{
	EnvType:           "development",
	Dicts:             references.DefaultConfig,
	DynamicResources:  dynamicresources.DefaultConfig,
	Logging:           logging.DefaultConfig,
	Grpc:              grpcserver.DefaultGrpcConfig,
	HTTP:              httpserver.DefaultHTTPConfig,
	Tvm:               tvm.DefaultConfig,
	Geobase:           geobase.DefaultConfig,
	OrdersClient:      clients.DefaultHTTPConfig,
	HealthCheck:       healthcheck.DefaultHealthCheckConfig,
	Probes:            probes.DefaultHTTPConfig,
	UnprocessedOrders: unprocessedorders.DefaultConfig,
	Testing:           testing.DefaultConfig,
	Database:          db.DefaultConfig,
	RaspMediaURL:      "https://yastat.net/s3/rasp/media",
	ContentAdmin:      contentadmin.DefaultConfig,
	CityImages:        cityimages.DefaultConfig,
	AfishaClient:      activityclients.DefaultAfishaConfig,
	IziTravelClient:   activityclients.DefaultIziTravelConfig,
	Provider:          trips.DefaultProviderCfg,
	Notifier:          notifier.DefaultConfig,
	SharedFlights:     sharedflights.DefaultConfig,
	WeatherProvider:   apiweather.DefaultConfig,
	WeatherClient:     weather.DefaultHTTPClientConfig,
	RateLimits:        DefaultRateLimits,
}
