package async

type BlockType string

const (
	ActivitiesBlock BlockType = "ACTIVITIES"
)

func ParseBlockType(rawTypes []string) ([]BlockType, error) {
	result := make([]BlockType, 0, len(rawTypes))
	for _, rawType := range rawTypes {
		blockType := BlockType(rawType)
		switch rawType {
		case string(ActivitiesBlock):
			result = append(result, blockType)
		default:
			return nil, ErrUnexpectedAsyncBlockType
		}
	}
	return result, nil
}
