package displaytime

import "time"

type DatesPairArgs struct {
	userTime    time.Time
	start       time.Time
	end         time.Time
	useYear     bool // пример: "25 мая, 2012"
	useRelative bool // пример: "послезавтра"
	shortMonth  bool // пример: "25 дек"
}

func NewDatesPairArgs(userTime, start, end time.Time) *DatesPairArgs {
	return &DatesPairArgs{
		userTime: userTime,
		start:    start,
		end:      end,
	}
}

func (args DatesPairArgs) SetUseYear(flags ...bool) *DatesPairArgs {
	args.useYear = allOrTrue(flags)
	return &args
}

func (args DatesPairArgs) SetUseRelative(flags ...bool) *DatesPairArgs {
	args.useRelative = allOrTrue(flags)
	return &args
}

type DateTimeArgs struct {
	userTime    time.Time
	time        *time.Time
	useYear     bool // пример: "25 мая, 2012"
	useRelative bool // пример: "послезавтра"
}

func NewDateTimeArgs(userTime time.Time, t *time.Time) *DateTimeArgs {
	return &DateTimeArgs{
		userTime: userTime,
		time:     t,
	}
}

func (args DateTimeArgs) SetUseYear(flags ...bool) *DateTimeArgs {
	args.useYear = allOrTrue(flags)
	return &args
}

func (args DateTimeArgs) SetUseRelative(flags ...bool) *DateTimeArgs {
	args.useRelative = allOrTrue(flags)
	return &args
}

func (args DatesPairArgs) SetShortMonth(flags ...bool) *DatesPairArgs {
	args.shortMonth = allOrTrue(flags)
	return &args
}

func allOrTrue(flags []bool) bool {
	for _, flag := range flags {
		if !flag {
			return false
		}
	}
	return true
}
