# GetActiveTrips
### Описание
Возвращает активные поездки для заданного passport_id

### Path
`/external-api/v1/get-active-trips`

### Заголовки
| Поле                | Комментарий     |
|---------------------|-----------------|
| X-Ya-Service-Ticket | Сервисный тикет |

### Параметры урла

| Поле           |       Тип        | Комментарий                              | Required | Default |
|----------------|:----------------:|------------------------------------------|----------|---------|
| passport_id    |      String      | Id паспорта пользователя                 | true     |         |
| geo_id         |       Int        | Локация пользователя по геобазе          | true     |         |
| limit          |       Int        | Максимальное количество поездок в ответе | false    | 3       |

### Схема ответа для формата 1.1.0
```json
{
    "trips": [
        {
            "type": "REAL",
            "item": {
                "title": "Москва — Санкт-Петербург",
                "image": "https://avatars.mds.yandex.net/get-rasp/1521905/ac391683-c731-429c-a7b6-517410d595c1/36x36",
                "display_date": "15 — 19 авг, 2022"
            },
            "state": "CONFIRMED"
        }
    ]
}
```

Если данных по пользователю нет
```json
{
    "trips": []
}
```

### Коды ответа
`404` - не найден пользователь \
`500` - все пропало
