package http

import (
	"fmt"
	"net/http"
	"strconv"

	"a.yandex-team.ru/library/go/valid/v2"
	"a.yandex-team.ru/library/go/valid/v2/rule"
)

const defaultActiveTripsLimit = 3

type GetActiveTripsForm struct {
	PassportID string
	GeoID      int
	Limit      int
}

func (form *GetActiveTripsForm) Parse(r *http.Request) error {
	form.PassportID = r.URL.Query().Get("passport_id")
	form.Limit = defaultActiveTripsLimit

	var err error
	if rawLimit := r.URL.Query().Get("limit"); rawLimit != "" {
		form.Limit, err = strconv.Atoi(rawLimit)
		if err != nil {
			return fmt.Errorf("unable to parse 'limit': %w", err)
		}
	}
	if rawGeoID := r.URL.Query().Get("geo_id"); rawGeoID != "" {
		form.GeoID, err = strconv.Atoi(rawGeoID)
		if err != nil {
			return fmt.Errorf("unable to parse 'geo_id': %w", err)
		}
	}

	err = valid.Struct(
		&form,
		valid.Value(&form.PassportID, rule.Required),
		valid.Value(&form.Limit, rule.InRange(1, 20)),
		valid.Value(&form.GeoID, rule.Required),
	)
	if err != nil {
		return fmt.Errorf("unable to parse request: \"%+v\"", err)
	}
	return nil
}
