package http

type GetActiveTripsResponse struct {
	Trips []*TripListItem `json:"trips"`
}

type TripListItem struct {
	Type  TripListItemType  `json:"type"`
	Item  iTripListItem     `json:"item"`
	State TripListItemState `json:"state"`
}

type TripListItemType string

var (
	RealItem  TripListItemType = "REAL"
	OrderItem TripListItemType = "ORDER"
)

type TripListItemState string

var (
	TripStateConfirmed TripListItemState = "CONFIRMED"
	TripStateCancelled TripListItemState = "CANCELLED"
)

type iTripListItem interface {
	isTripListItem()
}

type TripListItemReal struct {
	iTripListItem

	ID          string `json:"id"`
	Title       string `json:"title"`
	Image       string `json:"image,omitempty"`
	DisplayDate string `json:"display_date"`
}

type TripListItemOrder struct {
	iTripListItem

	OrderID     string `json:"order_id"`
	Title       string `json:"title"`
	Image       string `json:"image,omitempty"`
	DisplayDate string `json:"display_date"`
}
