package models

import (
	"time"

	tripsapi "a.yandex-team.ru/travel/komod/trips/api/trips/v1"
	ordersproto "a.yandex-team.ru/travel/orders/proto"
	travelproto "a.yandex-team.ru/travel/proto"
)

type BlockRsp interface {
	isBlockRsp()
}

type AviaOrders struct {
	BlockRsp
	Values []AviaOrder
}

type AviaOrder struct {
	ID                  string
	Title               string
	ForwardDeparture    time.Time
	DisplayDateForward  string
	DisplayDateBackward string
	Pnr                 string
	RegistrationURL     string
	Companies           []Company
	State               ordersproto.EDisplayOrderState
	TripOrderState      tripsapi.TripOrderState
}

type Company struct {
	Title   string
	LogoURL string
	Color   string
}

type TrainOrders struct {
	BlockRsp
	Values []TrainOrder
}

type BusOrders struct {
	BlockRsp
	Values []BusOrder
}

type TrainOrder struct {
	ID                           string
	Title                        string
	ForwardDeparture             time.Time
	DisplayDateForward           string
	DisplayDateBackward          string
	PrintURL                     string
	Trains                       []Train
	HasTransferWithStationChange bool
	State                        ordersproto.EDisplayOrderState
	TripOrderState               tripsapi.TripOrderState
	RefundedTicketsCount         uint16
}

type BusOrder struct {
	ID                   string
	Title                string
	ForwardDeparture     time.Time
	DisplayDateForward   string
	DownloadBlankToken   string
	Description          string
	CarrierName          string
	State                ordersproto.EDisplayOrderState
	TripOrderState       tripsapi.TripOrderState
	RefundedTicketsCount uint16
}

type Train struct {
	Number      string
	Description string
}

type HotelOrders struct {
	BlockRsp
	Values []HotelOrder
}

type HotelOrder struct {
	ID             string
	Title          string
	Stars          uint32
	CheckinDate    time.Time
	DisplayDates   string
	Address        string
	Image          string
	Coordinates    *travelproto.TCoordinates
	State          ordersproto.EDisplayOrderState
	DocumentURL    string
	TripOrderState tripsapi.TripOrderState
}

type HotelsCrossSale struct {
	BlockRsp
	Title              string
	CheckInDate        time.Time
	CheckOutDate       time.Time
	Adults             uint
	ChildrenAges       []uint
	SettlementPointKey string
	TotalHotelLimit    uint
}

type AsyncBlockRsp interface {
	BlockRsp
	isAsyncBlockRsp()
}

type ActivitiesBlock struct {
	AsyncBlockRsp
	Blocks []Activity
}

type Activity interface {
	isActivity()
}

type AfishaEventInfo struct {
	Activity
	Name     string
	MinPrice *Price
	Type     string
	DateTime string
	DateText string
	ImageURL string
	EventURL string
	Tags     []string
}

type Price struct {
	Value    float64
	Currency string
}

type IziTravelTourInfo struct {
	Activity
	Name     string
	ImageURL string
	TourURL  string
	Type     string
	Category string
	Duration int
}

type RestrictionsBlock struct {
	BlockRsp
	FromCountryTitle string
	ToCountryTitle   string
	FromGeoID        int
	ToGeoID          int
	FromPointKey     string
	ToPointKey       string
}

type NotificationsBlock struct {
	BlockRsp
	Blocks []Notification
}

type NotificationType int

var (
	NotificationTypeAviaOnlineCheckIn    NotificationType = 0
	NotificationTypeHotelDeferredPayment NotificationType = 1
)

type Notification interface {
	isNotification()
	Type() NotificationType
	Priority() int
}

type HotelDeferredPaymentNotification struct {
	Notification
	Order HotelOrder

	priority int
}

func NewHotelDeferredPaymentNotification(order HotelOrder, priority int) *HotelDeferredPaymentNotification {
	return &HotelDeferredPaymentNotification{Order: order, priority: priority}
}

func (h *HotelDeferredPaymentNotification) Priority() int {
	return h.priority
}

func (h *HotelDeferredPaymentNotification) Type() NotificationType {
	return NotificationTypeHotelDeferredPayment
}

type AviaOnlineCheckInNotification struct {
	Notification
	OrderID      string
	Airline      Company
	FlightNumber string
	FlightTitle  string

	AviaOfflineCheckIn AviaOfflineCheckIn
	RegistrationURL    string
	Pnr                string

	// 2022-02-09T07:27:50.107Z
	UpdatedAt string

	priority int
}

func NewAviaOnlineCheckInNotification(
	orderID string,
	airline Company,
	flightNumber string,
	flightTitle string,
	aviaOfflineCheckIn AviaOfflineCheckIn,
	registrationURL string,
	pnr string,
	updatedAt string,
	priority int,
) *AviaOnlineCheckInNotification {
	return &AviaOnlineCheckInNotification{
		OrderID:            orderID,
		Airline:            airline,
		FlightNumber:       flightNumber,
		FlightTitle:        flightTitle,
		AviaOfflineCheckIn: aviaOfflineCheckIn,
		RegistrationURL:    registrationURL,
		Pnr:                pnr,
		UpdatedAt:          updatedAt,
		priority:           priority,
	}
}

func (a *AviaOnlineCheckInNotification) Type() NotificationType {
	return NotificationTypeAviaOnlineCheckIn
}

func (a *AviaOnlineCheckInNotification) Priority() int {
	return a.priority
}

type AviaOfflineCheckIn struct {
	CheckInCounters string
	Gate            string
}

type WeatherBlock struct {
	BlockRsp
	Forecast []*WeatherItem
}

type WeatherItem struct {
	ImageURL    string `json:"image_url"`
	Title       string `json:"title"`
	Description string `json:"description"`
	URL         string `json:"url"`
	ItemType    string `json:"item_type"`
}
