package models

import (
	"time"

	tripsapi "a.yandex-team.ru/travel/komod/trips/api/trips/v1"
)

type TripsRsp struct {
	Active *PaginatedTripsListRsp
	Past   *PaginatedTripsListRsp
}

type PaginatedTripsListRsp struct {
	Trips             []TripItemRsp
	ContinuationToken string
}

type TripItemRsp interface {
	isTripItem()
}

type OrderTripItemRsp struct {
	TripItemRsp
	OrderID     string
	Image       string
	Title       string
	DisplayDate string
	State       tripsapi.TripState
}

type RealTripItemRsp struct {
	TripItemRsp
	ID          string
	Image       string
	Title       string
	DisplayDate string
	OrderIDs    []string
	State       tripsapi.TripState
}

type TripRsp struct {
	ID          string
	Title       string
	State       tripsapi.TripState
	DisplayDate string
	BeginDate   time.Time
	EndDate     time.Time
	Image       string
	Blocks      []BlockRsp
}
