package trips

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/library/go/ptr"
	"a.yandex-team.ru/travel/komod/trips/internal/components/api/trips/models"
)

func GenerateStartToken(tripsType models.TripsType) *models.ContinuationToken {
	return &models.ContinuationToken{
		TripsType: tripsType,
	}
}

func DumpToken(token models.ContinuationToken) string {
	switch token.TripsType {
	case models.PastTrips, models.ActiveTrips:
	default:
		panic(fmt.Sprintf("unexpected token type %s", token.TripsType))
	}

	var nextTripID string
	if token.NextTripID != nil {
		nextTripID = *token.NextTripID
	}
	return fmt.Sprintf("%s_%s", token.TripsType, nextTripID)
}

func LoadToken(value string) (*models.ContinuationToken, error) {
	parts := strings.Split(value, "_")
	if len(parts) != 2 {
		return nil, fmt.Errorf("token has to contain two parts (value=%s)", value)
	}

	var nextTripID *string
	if len(parts[1]) != 0 {
		nextTripID = ptr.String(parts[1])
	}

	tripsType := models.TripsType(parts[0])
	switch tripsType {
	case models.PastTrips, models.ActiveTrips:
	default:
		return nil, fmt.Errorf("unexpected token type %s", tripsType)
	}

	return &models.ContinuationToken{
		TripsType:  tripsType,
		NextTripID: nextTripID,
	}, nil
}
