package trips

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/internal/orders"
)

type TrainDescriptionBuilder struct {
	logger log.Logger
}

func NewTrainDescriptionBuilder(logger log.Logger) *TrainDescriptionBuilder {
	return &TrainDescriptionBuilder{logger: logger}
}

func (b TrainDescriptionBuilder) Build(train *orders.Train) string {
	fromTitle := train.TrainInfo.StartSettlementTitle
	toTitle := train.TrainInfo.EndSettlementTitle
	if fromTitle == "" || toTitle == "" {
		return ""
	}

	return fmt.Sprintf(
		"Поезд %s %s — %s%s",
		train.TrainInfo.Number,
		fromTitle,
		toTitle,
		b.buildBrandDescriptionPart(train.TrainInfo.BrandTitle),
	)
}

func (b TrainDescriptionBuilder) buildBrandDescriptionPart(brandTitle string) string {
	if brandTitle == "" {
		return ""
	}
	return fmt.Sprintf(", %s", brandTitle)
}
