package dispatchers

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/api/processor/v1"
	"a.yandex-team.ru/travel/komod/trips/internal/services"
)

type OldOrders struct {
	*base
	logger log.Logger
}

func NewOldOrders(
	logger log.Logger,
	processorService services.Processor,
	unprocessedEntityService services.UnprocessedOrders,
) *OldOrders {
	logger = logger.WithName("collector.dispatchers.UnprocessedOrders")
	return &OldOrders{
		base:   newBase(logger, processorService, unprocessedEntityService),
		logger: logger,
	}
}

func (c *OldOrders) Dispatch(message []byte) error {
	req := new(processor.ProcessTripEntityReq)
	err := proto.Unmarshal(message, req)
	if err != nil {
		c.logger.Error("unexpected proto format", log.Binary("message", message))
		return nil
	}
	if order := req.GetOrder(); order != nil {
		c.dispatchOrder(order.Id, req.GetCollectedAt(), req.RetriesLeft)
	}
	return nil
}
